/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService111;
import org.geoserver.wcs.kvp.GetCoverageRequestReader;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geoserver.wcs.xml.v1_1_1.WCSConfiguration;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;
import org.opengis.coverage.grid.GridCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGetCoverageTest
extends WCSTestSupport {
    static final double EPS = 4.0;
    GetCoverageRequestReader kvpreader;
    WebCoverageService111 service;
    WCSConfiguration configuration;
    WcsXmlReader xmlReader;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.kvpreader = (GetCoverageRequestReader)applicationContext.getBean("wcs111GetCoverageRequestReader");
        this.service = (WebCoverageService111)applicationContext.getBean("wcs111ServiceTarget");
        this.configuration = new WCSConfiguration();
        this.xmlReader = new WcsXmlReader("GetCoverage", "1.1.1", this.configuration);
    }

    protected GridCoverage[] executeGetCoverageKvp(Map<String, Object> raw) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.kvpreader.read(this.kvpreader.createRequest(), this.parseKvp(raw), raw);
        return this.service.getCoverage(getCoverage);
    }

    protected Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.1.1");
        raw.put("request", "GetCoverage");
        return raw;
    }

    protected GridCoverage[] executeGetCoverageXml(String request) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.xmlReader.read(null, (Reader)new StringReader(request), null);
        return this.service.getCoverage(getCoverage);
    }

    protected void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    protected void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }
}

