/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.Arrays;
import java.util.List;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.Ows11Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wcs.WcsException;

public class BoundingBoxKvpParser
extends KvpParser {
    public BoundingBoxKvpParser() {
        super("BoundingBox", BoundingBoxType.class);
    }

    public Object parse(String value) throws Exception {
        List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        if (unparsed.size() < 4) {
            throw new WcsException("Requested bounding box contains wrongnumber of coordinates (should have at least 4): " + unparsed.size(), WcsException.WcsExceptionCode.InvalidParameterValue, "BoundingBox");
        }
        int size = unparsed.size();
        Double[] lower = new Double[(int)Math.floor((double)size / 2.0)];
        Double[] upper = new Double[lower.length];
        int i = 0;
        while (i < lower.length) {
            try {
                lower[i] = Double.parseDouble((String)unparsed.get(i));
            }
            catch (NumberFormatException e) {
                throw new WcsException("Bounding box coordinate is not parsable:" + unparsed.get(i * 2), WcsException.WcsExceptionCode.InvalidParameterValue, "BoundingBox");
            }
            try {
                upper[i] = Double.parseDouble((String)unparsed.get(lower.length + i));
            }
            catch (NumberFormatException e) {
                throw new WcsException("Bounding box coordinate is not parsable:" + unparsed.get(i * 2 + 1), WcsException.WcsExceptionCode.InvalidParameterValue, "BoundingBox");
            }
            ++i;
        }
        String crsName = null;
        CoordinateReferenceSystem crs = null;
        if (unparsed.size() % 2 == 1) {
            crsName = (String)unparsed.get(unparsed.size() - 1);
            try {
                if ("urn:ogc:def:crs:OGC:1.3:CRS84".equals(crsName)) {
                    crsName = "EPSG:4326";
                } else {
                    crs = CRS.decode((String)crsName);
                    if (crs.getCoordinateSystem().getDimension() != lower.length) {
                        throw new WcsException("CRS specified has dimension " + crs.getCoordinateSystem().getDimension() + " but bbox specified has " + lower.length, WcsException.WcsExceptionCode.InvalidParameterValue, "BoundingBox");
                    }
                }
            }
            catch (Exception e) {
                throw new WcsException("Could not recognize crs " + crsName, WcsException.WcsExceptionCode.InvalidParameterValue, "BoundingBox");
            }
        }
        BoundingBoxType bbt = Ows11Factory.eINSTANCE.createBoundingBoxType();
        bbt.setCrs(crsName);
        bbt.setLowerCorner(Arrays.asList(lower));
        bbt.setUpperCorner(Arrays.asList(upper));
        return bbt;
    }
}

