/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml.v1_1_1.bindings;

import java.net.URI;
import javax.xml.namespace.QName;
import org.geoserver.wcs.xml.v1_1_1.WCS;
import org.geotools.gml3.GML;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimePeriodTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return WCS.TimePeriodType;
    }

    public Class getType() {
        return Period.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String frameName = ((URI)node.getAttributeValue("frame", (Object)"#ISO-8601")).toString();
        NamedIdentifier frameID = new NamedIdentifier(Citations.CRS, frameName);
        DefaultTemporalReferenceSystem frame = new DefaultTemporalReferenceSystem((ReferenceIdentifier)frameID, null);
        DefaultInstant begining = new DefaultInstant((Position)node.getChild("BeginPosition").getValue());
        DefaultInstant ending = new DefaultInstant((Position)node.getChild("EndPosition").getValue());
        DefaultPeriod timePeriod = new DefaultPeriod((Instant)begining, (Instant)ending);
        return timePeriod;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        Period timePeriod = (Period)object;
        if (timePeriod == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    public Object getProperty(Object object, QName name) {
        Period timePeriod = (Period)object;
        if (timePeriod == null) {
            return null;
        }
        if (name.getLocalPart().equals("BeginPosition")) {
            return timePeriod.getBeginning().getPosition();
        }
        if (name.getLocalPart().equals("EndPosition")) {
            return timePeriod.getEnding().getPosition();
        }
        return null;
    }
}

