/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.w3c.dom.Document;

public class GetCoverageMultipartEncodingTest
extends WCSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetCoverageMultipartEncodingTest());
    }

    public void testKvpBasic() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326" + "&GridBaseCRS=urn:ogc:def:crs:EPSG:4326" + "&format=geotiff";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GetCoverageMultipartEncodingTest.assertTrue((boolean)response.getContentType().matches("multipart/related;\\s*boundary=\".*\""));
        Multipart multipart = this.getMultipart(response);
        GetCoverageMultipartEncodingTest.assertEquals((int)2, (int)multipart.getCount());
        BodyPart coveragesPart = multipart.getBodyPart(0);
        GetCoverageMultipartEncodingTest.assertEquals((String)"text/xml", (String)coveragesPart.getContentType());
        GetCoverageMultipartEncodingTest.assertEquals((String)"<urn:ogc:wcs:1.1:coverages>", (String)coveragesPart.getHeader("Content-ID")[0]);
        Document dom = this.dom(coveragesPart.getDataHandler().getInputStream());
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)MockData.TASMANIA_BM.getLocalPart(), (String)"wcs:Coverages/wcs:Coverage/ows:Title", (Document)dom);
        BodyPart coveragePart = multipart.getBodyPart(1);
        GetCoverageMultipartEncodingTest.assertEquals((String)"image/tiff;subtype=\"geotiff\"", (String)coveragePart.getContentType());
        GetCoverageMultipartEncodingTest.assertEquals((String)"<theCoverage>", (String)coveragePart.getHeader("Content-ID")[0]);
    }

    public void testArcgridException() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&format=application/arcgrid" + "&boundingbox=-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326";
        Document dom = this.getAsDOM(request);
        this.checkOws11Exception(dom);
    }

    private Multipart getMultipart(MockHttpServletResponse response) throws MessagingException, IOException {
        MimeMessage body = new MimeMessage(null, (InputStream)this.getBinaryInputStream(response));
        Multipart multipart = (Multipart)body.getContent();
        return multipart;
    }

    private GridCoverage2D readCoverage(InputStream is) throws Exception {
        GeoTiffReader reader = new GeoTiffReader((Object)is);
        GridCoverage2D coverage = reader.read(null);
        reader.dispose();
        return coverage;
    }

    public void testTiffOutput() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326" + "&GridBaseCRS=urn:ogc:def:crs:EPSG:4326" + "&format=image/tiff";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Multipart multipart = this.getMultipart(response);
        GetCoverageMultipartEncodingTest.assertEquals((int)2, (int)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        GetCoverageMultipartEncodingTest.assertEquals((String)"image/tiff", (String)coveragePart.getContentType());
        GetCoverageMultipartEncodingTest.assertEquals((String)"<theCoverage>", (String)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        reader.setInput(ImageIO.createImageInputStream(coveragePart.getInputStream()));
        reader.read(0);
    }

    public void testPngOutput() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326" + "&GridBaseCRS=urn:ogc:def:crs:EPSG:4326" + "&format=image/png";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Multipart multipart = this.getMultipart(response);
        GetCoverageMultipartEncodingTest.assertEquals((int)2, (int)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        GetCoverageMultipartEncodingTest.assertEquals((String)"image/png", (String)coveragePart.getContentType());
        GetCoverageMultipartEncodingTest.assertEquals((String)"<theCoverage>", (String)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
        reader.setInput(ImageIO.createImageInputStream(coveragePart.getInputStream()));
        reader.read(0);
    }

    public void testGeotiffNamesGalore() throws Exception {
        String requestBase = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326" + "&GridBaseCRS=urn:ogc:def:crs:EPSG:4326";
        this.ensureTiffFormat(this.getAsServletResponse(String.valueOf(requestBase) + "&format=geotiff"));
        this.ensureTiffFormat(this.getAsServletResponse(String.valueOf(requestBase) + "&format=geotiff"));
        this.ensureTiffFormat(this.getAsServletResponse(String.valueOf(requestBase) + "&format=image/geotiff"));
        this.ensureTiffFormat(this.getAsServletResponse(String.valueOf(requestBase) + "&format=GEotIFF"));
        this.ensureTiffFormat(this.getAsServletResponse(String.valueOf(requestBase) + "&format=image/tiff;subtype%3D\"geotiff\""));
    }

    private void ensureTiffFormat(MockHttpServletResponse response) throws MessagingException, IOException {
        GetCoverageMultipartEncodingTest.assertTrue((String)("Content type not mulipart but " + response.getContentType()), (boolean)response.getContentType().matches("multipart/related;\\s*boundary=\".*\""));
        Multipart multipart = this.getMultipart(response);
        BodyPart coveragePart = multipart.getBodyPart(1);
        GetCoverageMultipartEncodingTest.assertEquals((String)"image/tiff;subtype=\"geotiff\"", (String)coveragePart.getContentType());
    }
}

