/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.wcs.test.WCSTestSupport;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetCapabilitiesTest
extends WCSTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableCoverageStore(MockData.WORLD.getLocalPart());
    }

    public void testGetBasic() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptversions=1.1.1");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"TrueFalse", (String)"/wcs:Capabilities/ows:OperationsMetadata/ows:Operation[@name=\"GetCoverage\"]/ows:Parameter/ows:AllowedValues", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:Title[text()='World'])", (Document)dom);
    }

    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        CoverageInfo cvInfo = this.getCatalog().getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        cvInfo.setLatLonBoundingBox(null);
        this.getCatalog().save((ResourceInfo)cvInfo);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.1.1");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        int count = this.getCatalog().getCoverages().size();
        GetCapabilitiesTest.assertEquals((int)(count - 1), (int)dom.getElementsByTagName("wcs:CoverageSummary").getLength());
    }

    public void testIgnoreWCS10Version() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=9.9.9");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"TrueFalse", (String)"/wcs:Capabilities/ows:OperationsMetadata/ows:Operation[@name=\"GetCoverage\"]/ows:Parameter/ows:AllowedValues", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:Title[text()='World'])", (Document)dom);
    }

    public void testNamespaceFilter() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptversions=1.1.1&namespace=wcs");
        Element e = dom.getDocumentElement();
        GetCapabilitiesTest.assertEquals((String)"Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        GetCapabilitiesTest.assertTrue((xpath.getMatchingNodes("//wcs:CoverageSummary/ows:Title[starts-with(., wcs)]", dom).getLength() > 0 ? 1 : 0) != 0);
        GetCapabilitiesTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//wcs:CoverageSummary/ows:Title[not(starts-with(., wcs))]", dom).getLength());
        dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptversions=1.1.1&namespace=NoThere");
        e = dom.getDocumentElement();
        GetCapabilitiesTest.assertEquals((String)"Capabilities", (String)e.getLocalName());
        GetCapabilitiesTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
    }

    public void testNoServiceContactInfo() throws Exception {
        this.getGeoServer().getGlobal().setContact((ContactInfo)new ContactInfoImpl());
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
    }

    public void testPostBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
    }

    public void testUnsupportedVersionPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <ows:AcceptVersions>    <ows:Version>9.9.9</ows:Version>  </ows:AcceptVersions></wcs:GetCapabilities>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
        GetCapabilitiesTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getFirstChild().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"VersionNegotiationFailed", (String)"ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    public void testUnsupportedVersionGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptVersions=9.9.9,8.8.8");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"VersionNegotiationFailed", (String)"ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    public void testSupportedVersionGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptVersions=0.5.0,1.1.1");
        GetCapabilitiesTest.assertEquals((String)"wcs:Capabilities", (String)dom.getFirstChild().getNodeName());
    }

    public void testSupportedVersionPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <ows:AcceptVersions>    <ows:Version>0.5.0</ows:Version>    <ows:Version>1.1.1</ows:Version>  </ows:AcceptVersions></wcs:GetCapabilities>";
        Document dom = this.postAsDOM("wcs", request);
        GetCapabilitiesTest.assertEquals((String)"wcs:Capabilities", (String)dom.getFirstChild().getNodeName());
    }

    public void testUpdateSequenceInferiorGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=-1");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        GetCapabilitiesTest.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    public void testUpdateSequenceInferiorPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"-1\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        GetCapabilitiesTest.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    public void testUpdateSequenceEqualsGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=0");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        GetCapabilitiesTest.assertEquals((int)0, (int)root.getChildNodes().getLength());
    }

    public void testUpdateSequenceEqualsPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"0\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        GetCapabilitiesTest.assertEquals((int)0, (int)root.getChildNodes().getLength());
    }

    public void testUpdateSequenceSuperiorGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=1");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
    }

    public void testUpdateSequenceSuperiorPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"1\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
    }

    public void testSectionsBogus() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=Bogus");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
        XMLAssert.assertXpathEvaluatesTo((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)"/ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    public void testSectionsAll() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=All");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Contents)", (Document)dom);
    }

    public void testOneSection() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=ServiceProvider");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wcs:Contents)", (Document)dom);
    }

    public void testTwoSection() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=ServiceProvider,Contents");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Contents)", (Document)dom);
    }

    public void testWorkspaceQualified() throws Exception {
        int all = this.getCatalog().getCoverageStores().size() - 1;
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        GetCapabilitiesTest.assertEquals((int)all, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
        int some = this.getCatalog().getCoverageStoresByWorkspace("cdf").size();
        GetCapabilitiesTest.assertTrue((some < all ? 1 : 0) != 0);
        dom = this.getAsDOM("cdf/wcs?request=GetCapabilities&service=WCS");
        GetCapabilitiesTest.assertEquals((int)some, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
    }

    public void testLayerQualified() throws Exception {
        int all = this.getCatalog().getCoverageStores().size() - 1;
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        GetCapabilitiesTest.assertEquals((int)all, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
        dom = this.getAsDOM("wcs/BlueMarble/wcs?request=GetCapabilities&service=WCS");
        GetCapabilitiesTest.assertEquals((int)1, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
    }

    public void testNonAdvertisedLayer() throws Exception {
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        try {
            Document dom = this.getAsDOM("wcs?request=GetCapabilities");
            XMLAssert.assertXpathExists((String)"//wcs:CoverageSummary[ows:Title='DEM']", (Document)dom);
            layer.setAdvertised(false);
            this.getCatalog().save(layer);
            dom = this.getAsDOM("wcs?request=GetCapabilities");
            XMLAssert.assertXpathNotExists((String)"//wcs:CoverageSummary[ows:Title='DEM']", (Document)dom);
        }
        finally {
            layer.setAdvertised(true);
            this.getCatalog().save(layer);
        }
    }
}

