/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import net.opengis.wcs11.DescribeCoverageType;
import org.geoserver.wcs.xml.v1_1_1.WCSConfiguration;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;

public class DescribeCoverageXmlParserTest
extends TestCase {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    protected void setUp() throws Exception {
        super.setUp();
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("DescribeCoverage", "1.1.1", this.configuration);
    }

    public void testBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1 schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <wcs:Identifier>wcs:BlueMarble</wcs:Identifier>\r\n</wcs:DescribeCoverage>";
        DescribeCoverageType cap = (DescribeCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        DescribeCoverageXmlParserTest.assertEquals((String)"WCS", (String)cap.getService());
        DescribeCoverageXmlParserTest.assertEquals((String)"1.1.1", (String)cap.getVersion());
        DescribeCoverageXmlParserTest.assertEquals((int)1, (int)cap.getIdentifier().size());
        DescribeCoverageXmlParserTest.assertEquals((Object)"wcs:BlueMarble", (Object)cap.getIdentifier().get(0));
    }
}

