/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import junit.framework.Test;
import junit.textui.TestRunner;
import net.opengis.wcs11.GetCoverageType;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wcs.WebCoverageService111;
import org.geoserver.wcs.kvp.GetCoverageRequestReader;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geoserver.wcs.xml.v1_1_1.WCSConfiguration;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCoverageTest
extends WCSTestSupport {
    private static final double EPS = 4.0;
    private GetCoverageRequestReader kvpreader;
    private WebCoverageService111 service;
    private WCSConfiguration configuration;
    private WcsXmlReader xmlReader;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetCoverageTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.kvpreader = (GetCoverageRequestReader)applicationContext.getBean("wcs111GetCoverageRequestReader");
        this.service = (WebCoverageService111)applicationContext.getBean("wcs111ServiceTarget");
        this.configuration = new WCSConfiguration();
        this.xmlReader = new WcsXmlReader("GetCoverage", "1.1.1", this.configuration);
    }

    protected String getLogConfiguration() {
        return "/DEFAULT_LOGGING.properties";
    }

    public void testKvpBasic() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)1, (int)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        GetCoverageTest.assertEquals((Object)CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326"), (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
    }

    private Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.1.1");
        raw.put("request", "GetCoverage");
        return raw;
    }

    public void testAntimeridianWorld() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.WORLD);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "175,10,-175,20,urn:ogc:def:crs:OGC:1.3:CRS84");
        raw.put("store", "false");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)1, (int)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        GetCoverageTest.assertEquals((Object)CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326"), (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
    }

    public void testAntimeridianTaz() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("store", "false");
        raw.put("BoundingBox", "145,-80,-175,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "147,-80,-175,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "147.2,-80,147,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "175,-80,147,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "175,-80,150,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
    }

    public void testWrongFormatParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "SuperCoolFormat");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"When did we learn to encode SuperCoolFormat?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"format", (String)e.getLocator());
        }
    }

    public void testDefaultGridOrigin() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        AffineTransform2D tx = (AffineTransform2D)coverages[0].getGridGeometry().getGridToCRS();
        GetCoverageTest.assertEquals((Object)0.0, (Object)tx.getTranslateX());
        GetCoverageTest.assertEquals((Object)0.0, (Object)tx.getTranslateY());
    }

    public void testWrongGridOrigin() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridOrigin", "12,13,14");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"GridOrigin", (String)e.getLocator());
        }
    }

    public void testWrongGridOffsets() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridOffsets", "12,13,14");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"GridOffsets", (String)e.getLocator());
        }
    }

    public void testNoGridOffsets() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GridCoverage original = this.getCatalog().getCoverageByName(getLayerId).getGridCoverage(null, null);
        AffineTransform2D originalTx = (AffineTransform2D)original.getGridGeometry().getGridToCRS();
        AffineTransform2D flippedTx = (AffineTransform2D)coverages[0].getGridGeometry().getGridToCRS();
        GetCoverageTest.assertEquals((double)originalTx.getScaleX(), (double)flippedTx.getShearY(), (double)4.0);
        GetCoverageTest.assertEquals((double)originalTx.getScaleY(), (double)flippedTx.getShearX(), (double)4.0);
        GetCoverageTest.assertEquals((double)originalTx.getShearX(), (double)flippedTx.getScaleY(), (double)4.0);
        GetCoverageTest.assertEquals((double)originalTx.getShearY(), (double)flippedTx.getScaleX(), (double)4.0);
        GetCoverageTest.assertEquals((double)0.0, (double)flippedTx.getTranslateY(), (double)4.0);
        GetCoverageTest.assertEquals((double)0.0, (double)flippedTx.getTranslateX(), (double)4.0);
    }

    public void testGridOffsetsSubsample() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridType", "urn:ogc:def:method:WCS:1.1:2dSimpleGrid");
        raw.put("GridOffsets", "0.1,0.1");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        AffineTransform2D flippedTx = (AffineTransform2D)coverages[0].getGridGeometry().getGridToCRS();
        GetCoverageTest.assertEquals((double)0.0, (double)flippedTx.getShearY(), (double)4.0);
        GetCoverageTest.assertEquals((double)0.0, (double)flippedTx.getShearX(), (double)4.0);
        GetCoverageTest.assertEquals((double)0.1, (double)flippedTx.getScaleY(), (double)4.0);
        GetCoverageTest.assertEquals((double)0.1, (double)flippedTx.getScaleX(), (double)4.0);
        GetCoverageTest.assertEquals((double)0.0, (double)flippedTx.getTranslateY(), (double)4.0);
        GetCoverageTest.assertEquals((double)0.0, (double)flippedTx.getTranslateX(), (double)4.0);
    }

    public void testInvalidRangeSubset() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("rangeSubset", "jimbo:nearest");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"RangeSubset", (String)e.getLocator());
        }
        raw.put("rangeSubset", "contents:nearest[MadAxis[key]]");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"RangeSubset", (String)e.getLocator());
        }
        raw.put("rangeSubset", "contents:nearest[Bands[MadKey]]");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"RangeSubset", (String)e.getLocator());
        }
    }

    public void testRangeSubsetSingle() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        String[] bands = new String[]{"red_band", "grEEN_band", "Blue_band"};
        for (int i = 0; i < bands.length; ++i) {
            raw.put("rangeSubset", "contents:nearest[Bands[" + bands[i] + "]]");
            GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
            GetCoverageTest.assertEquals((int)1, (int)coverages[0].getNumSampleDimensions());
            String coverageBand = coverages[0].getSampleDimension(0).getDescription().toString();
            GetCoverageTest.assertEquals((String)bands[i].toLowerCase(), (String)coverageBand.toLowerCase());
        }
    }

    public void testRangeSubsetMulti() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("rangeSubset", "contents:nearest[Bands[RED_BAND,BLUE_BAND]]");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)2, (int)coverages[0].getNumSampleDimensions());
        GetCoverageTest.assertEquals((String)"RED_BAND", (String)coverages[0].getSampleDimension(0).getDescription().toString());
        GetCoverageTest.assertEquals((String)"BLUE_BAND", (String)coverages[0].getSampleDimension(1).getDescription().toString());
    }

    public void testRangeSubsetSwap() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("rangeSubset", "contents:nearest[Bands[BLUE_BAND,GREEN_BAND]]");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)2, (int)coverages[0].getNumSampleDimensions());
        GetCoverageTest.assertEquals((String)"BLUE_BAND", (String)coverages[0].getSampleDimension(0).getDescription().toString());
        GetCoverageTest.assertEquals((String)"GREEN_BAND", (String)coverages[0].getSampleDimension(1).getDescription().toString());
    }

    public void testRangeSubsetOnlyInterpolation() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG::4326");
        raw.put("rangeSubset", "contents:nearest");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)3, (int)coverages[0].getNumSampleDimensions());
    }

    public void testRangeSubsetOnlyField() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG::4326");
        raw.put("rangeSubset", "contents");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)3, (int)coverages[0].getNumSampleDimensions());
    }

    public void testNullGridOrigin() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:GetCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1 schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <ows:Identifier>wcs:BlueMarble</ows:Identifier>\r\n  <wcs:DomainSubset>\r\n    <ows:BoundingBox crs=\"urn:ogc:def:crs:EPSG:6.6:4326\">\r\n      <ows:LowerCorner>-90 -180</ows:LowerCorner>\r\n      <ows:UpperCorner>90 180</ows:UpperCorner>\r\n    </ows:BoundingBox>\r\n  </wcs:DomainSubset>\r\n  <wcs:Output format=\"image/tiff\">\r\n    <wcs:GridCRS>\r\n      <wcs:GridBaseCRS>urn:ogc:def:crs:EPSG:6.6:4326</wcs:GridBaseCRS>\r\n      <wcs:GridType>urn:ogc:def:method:WCS:1.1:2dSimpleGrid</wcs:GridType>\r\n      <wcs:GridOffsets>1 2</wcs:GridOffsets>\r\n    </wcs:GridCRS>\r\n  </wcs:Output>\r\n</wcs:GetCoverage>";
        this.executeGetCoverageXml(request);
    }

    public void testStoreSupported() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326" + "&GridBaseCRS=urn:ogc:def:crs:EPSG:4326" + "&format=geotiff&store=true";
        Document dom = this.getAsDOM(request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)MockData.TASMANIA_BM.getLocalPart(), (String)"wcs:Coverages/wcs:Coverage/ows:Title", (Document)dom);
        String path = xpath.evaluate("//ows:Reference/@xlink:href", dom);
        File temp = new File(this.getTestData().getDataDirectoryRoot(), "temp");
        if (!temp.exists()) {
            temp.mkdir();
        }
        File wcsTemp = new File(temp, "wcs");
        wcsTemp.mkdir();
        File coverageFile = new File(wcsTemp, path.substring(path.lastIndexOf("/") + 1)).getAbsoluteFile();
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        reader.setInput(ImageIO.createImageInputStream(coverageFile));
        reader.read(0);
        String localPath = path.substring(path.indexOf("geoserver/") + 10);
        MockHttpServletResponse response = this.getAsServletResponse(localPath);
        reader.setInput(ImageIO.createImageInputStream(this.getBinaryInputStream(response)));
        reader.read(0);
        reader.dispose();
    }

    GridCoverage[] executeGetCoverageKvp(Map<String, Object> raw) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.kvpreader.read(this.kvpreader.createRequest(), this.parseKvp(raw), raw);
        return this.service.getCoverage(getCoverage);
    }

    GridCoverage[] executeGetCoverageXml(String request) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.xmlReader.read(null, (Reader)new StringReader(request), null);
        return this.service.getCoverage(getCoverage);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GetCoverageTest.suite());
    }
}

