/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.crs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRSAreaOfValidityMapBuilder {
    private static final int DEFAULT_MAP_WIDTH = 400;
    private static final int DEFAULT_MAP_HEIGHT = 200;
    private static final GeometryFactory gf = new GeometryFactory();
    private final int mapWidth;
    private final int mapHeight;
    private static Map<String, Style> STYLES = new WeakHashMap<String, Style>();
    private static WeakReference<DataStore> LATLON = null;

    public CRSAreaOfValidityMapBuilder() {
        this(400, 200);
    }

    public CRSAreaOfValidityMapBuilder(int mapWidth, int mapHeight) {
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
    }

    private FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(URL shpfile) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, "false");
        params.put(ShapefileDataStoreFactory.URLP.key, shpfile);
        DataStore ds = DataStoreFinder.getDataStore(params);
        return ds.getFeatureSource(ds.getTypeNames()[0]);
    }

    private Geometry getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        Polygon geogBoundingGeom;
        GeographicBoundingBox envelope = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)crs);
        if (envelope == null) {
            return null;
        }
        double westBoundLongitude = envelope.getWestBoundLongitude();
        double eastBoundLongitude = envelope.getEastBoundLongitude();
        double southBoundLatitude = envelope.getSouthBoundLatitude();
        double northBoundLatitude = envelope.getNorthBoundLatitude();
        int numSteps = 80;
        if (westBoundLongitude < eastBoundLongitude) {
            geogBoundingGeom = this.createBoundingPolygon(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude, 80);
        } else {
            Polygon eastPolygon = this.createBoundingPolygon(-180.0, eastBoundLongitude, southBoundLatitude, northBoundLatitude, 80);
            Polygon westPolygon = this.createBoundingPolygon(westBoundLongitude, 180.0, southBoundLatitude, northBoundLatitude, 80);
            geogBoundingGeom = gf.createMultiPolygon(new Polygon[]{eastPolygon, westPolygon});
        }
        return geogBoundingGeom;
    }

    private Polygon createBoundingPolygon(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude, int numSteps) {
        int i;
        double dx = (eastBoundLongitude - westBoundLongitude) / (double)numSteps;
        double dy = (northBoundLatitude - southBoundLatitude) / (double)numSteps;
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(4 * numSteps + 1);
        double x = westBoundLongitude;
        for (int i2 = 0; i2 < numSteps; ++i2) {
            coords.add(new Coordinate(x, southBoundLatitude));
            x += dx;
        }
        double y = southBoundLatitude;
        for (i = 0; i < numSteps; ++i) {
            coords.add(new Coordinate(eastBoundLongitude, y));
            y += dy;
        }
        x = eastBoundLongitude;
        for (i = 0; i < numSteps; ++i) {
            coords.add(new Coordinate(x, northBoundLatitude));
            x -= dx;
        }
        y = northBoundLatitude;
        for (i = 0; i < numSteps; ++i) {
            coords.add(new Coordinate(westBoundLongitude, y));
            y -= dy;
        }
        coords.add(new Coordinate(westBoundLongitude, southBoundLatitude));
        Coordinate[] coordinates = coords.toArray(new Coordinate[coords.size()]);
        LinearRing shell = gf.createLinearRing(coordinates);
        Polygon polygon = gf.createPolygon(shell, null);
        return polygon;
    }

    private Style getStyle(String styleName) {
        Style style = STYLES.get(styleName);
        if (style == null) {
            StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
            SLDParser parser = new SLDParser(styleFactory);
            try {
                parser.setInput(this.getClass().getResource(styleName));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            StyledLayerDescriptor sld = parser.parseSLD();
            UserLayer layer = (UserLayer)sld.getStyledLayers()[0];
            style = layer.getUserStyles()[0];
            STYLES.put(styleName, style);
        }
        return style;
    }

    public RenderedImage createMapFor(CoordinateReferenceSystem crs, Envelope areaOfInterest) throws IOException {
        BufferedImage image = new BufferedImage(this.mapWidth, this.mapHeight, 2);
        Graphics2D graphics = image.createGraphics();
        this.createMapFor(crs, areaOfInterest, graphics);
        graphics.dispose();
        return image;
    }

    public void createMapFor(CoordinateReferenceSystem crs, Envelope areaOfInterest, Graphics2D graphics) throws IOException {
        Geometry geographicBoundingBox = this.getGeographicBoundingBox(crs);
        MapContext mapContext = this.getMapContext(crs, geographicBoundingBox, areaOfInterest);
        graphics.setColor(new Color(153, 179, 204));
        graphics.fillRect(0, 0, this.mapWidth, this.mapHeight);
        Rectangle paintArea = new Rectangle(this.mapWidth, this.mapHeight);
        mapContext.setAreaOfInterest(areaOfInterest, crs);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext(mapContext);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderer.setJava2DHints(hints);
        HashMap<String, Boolean> renderingHints = new HashMap<String, Boolean>();
        renderingHints.put("optimizedDataLoadingEnabled", Boolean.TRUE);
        renderingHints.put("advancedProjectionHandling", Boolean.TRUE);
        renderer.setRendererHints(renderingHints);
        renderer.paint(graphics, paintArea, areaOfInterest);
    }

    private SimpleFeature createCrsBoundsFeature(Geometry geom, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.setName("Bounds");
        try {
            sftb.add("the_geom", Geometry.class, CRS.decode((String)"EPSG:4326", (boolean)true));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SimpleFeatureType featureType = sftb.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.template((SimpleFeatureType)featureType, null);
        feature.setAttribute("the_geom", (Object)geom);
        return feature;
    }

    private MapLayer createCrsLayer(Geometry geom, CoordinateReferenceSystem crs) {
        FeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Feature)this.createCrsBoundsFeature(geom, crs));
        Style style = this.getStyle("crs.sld");
        DefaultMapLayer ml = new DefaultMapLayer(collection, style);
        return ml;
    }

    private MapContext getMapContext(CoordinateReferenceSystem crs, Geometry geographicBoundingBox, Envelope areaOfInterest) throws IOException {
        DefaultMapContext mapContext = new DefaultMapContext();
        URL shpfile = this.getClass().getResource("TM_WORLD_BORDERS.shp");
        FeatureSource<SimpleFeatureType, SimpleFeature> source = this.getFeatureSource(shpfile);
        Style style = this.getStyle("TM_WORLD_BORDERS.sld");
        mapContext.addLayer((MapLayer)new DefaultMapLayer(source, style));
        source = this.getLatLonFeatureSource();
        style = this.getStyle("latlon.sld");
        mapContext.addLayer((MapLayer)new DefaultMapLayer(source, style));
        shpfile = this.getClass().getResource("cities.shp");
        source = this.getFeatureSource(shpfile);
        style = this.getStyle("cities.sld");
        mapContext.addLayer((MapLayer)new DefaultMapLayer(source, style));
        MapLayer layer = this.createCrsLayer(geographicBoundingBox, crs);
        mapContext.addLayer(layer);
        return mapContext;
    }

    private FeatureSource<SimpleFeatureType, SimpleFeature> getLatLonFeatureSource() {
        try {
            DataStore ds;
            DataStore dataStore = ds = LATLON == null ? null : (DataStore)LATLON.get();
            if (ds == null) {
                ds = this.createLatLonDataStore();
                LATLON = new WeakReference<DataStore>(ds);
            }
            return ds.getFeatureSource("latlon");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DataStore createLatLonDataStore() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("latlon");
        tb.add("the_geom", LineString.class, CRS.decode((String)"EPSG:4326", (boolean)true));
        tb.add("level", Integer.class);
        SimpleFeatureType type = tb.buildFeatureType();
        MemoryDataStore ds = new MemoryDataStore();
        ds.createSchema(type);
        FeatureWriter writer = ds.getFeatureWriterAppend("latlon", Transaction.AUTO_COMMIT);
        for (int lon = -180; lon < 180; lon += 5) {
            for (int lat = -90; lat < 90; lat += 5) {
                LineString geom = gf.createLineString(new Coordinate[]{new Coordinate((double)lon, (double)lat), new Coordinate((double)lon, (double)(lat + 5))});
                int level = 1;
                if (lon % 10 == 0) {
                    level = 10;
                }
                if (lon % 30 == 0) {
                    level = 30;
                }
                SimpleFeature f = (SimpleFeature)writer.next();
                f.setAttribute(0, (Object)geom);
                f.setAttribute(1, (Object)level);
                writer.write();
                geom = gf.createLineString(new Coordinate[]{new Coordinate((double)lon, (double)lat), new Coordinate((double)(lon + 5), (double)lat)});
                level = 1;
                if (lat % 10 == 0) {
                    level = 10;
                }
                if (lat % 30 == 0) {
                    level = 30;
                }
                f = (SimpleFeature)writer.next();
                f.setAttribute(0, (Object)geom);
                f.setAttribute(1, (Object)level);
                writer.write();
            }
        }
        writer.close();
        return ds;
    }
}

