/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.EqualInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.RolesFormComponent;
import org.geoserver.web.security.user.UserPage;

public abstract class AbstractUserPage
extends GeoServerSecuredPage {
    TextField username;

    protected AbstractUserPage(UserUIModel user) {
        Model userModel = new Model((Serializable)user);
        Form form = new Form("userForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)userModel));
        this.setModel((IModel)userModel);
        this.add((Component)form);
        this.username = new TextField("username");
        form.add((Component)this.username);
        PasswordTextField pw1 = new PasswordTextField("password").setResetPassword(false);
        PasswordTextField pw2 = new PasswordTextField("confirmPassword").setResetPassword(false);
        form.add((Component)pw1);
        form.add((Component)pw2);
        form.add((Component)new RolesFormComponent("roles", (IModel)new PropertyModel((Object)userModel, "authorities"), form, false));
        form.add((Component)new BookmarkablePageLink("cancel", UserPage.class));
        form.add((Component)this.saveLink());
        form.add((IFormValidator)new EqualInputValidator((FormComponent)pw1, (FormComponent)pw2));
        this.username.setRequired(true);
    }

    SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                AbstractUserPage.this.onFormSubmit();
            }
        };
    }

    protected abstract void onFormSubmit();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserUIModel
    implements Serializable {
        String username;
        String originalPassword;
        String password;
        String confirmPassword;
        List<String> authorities;
        boolean enabled;

        public UserUIModel(UserDetails acegiUser) {
            this.username = acegiUser.getUsername();
            this.password = this.originalPassword = acegiUser.getPassword();
            this.confirmPassword = this.originalPassword;
            this.authorities = this.toRoleList(acegiUser);
            this.enabled = acegiUser.isEnabled();
        }

        public UserUIModel() {
            this.authorities = new ArrayList<String>();
            this.enabled = true;
        }

        public User toAcegiUser() {
            return new User(this.username, this.password, this.enabled, true, true, true, this.toGrantedAuthorities(this.authorities));
        }

        List<String> toRoleList(UserDetails acegiUser) {
            ArrayList<String> result = new ArrayList<String>(acegiUser.getAuthorities().length);
            GrantedAuthority[] grantedAuthorityArray = acegiUser.getAuthorities();
            int n = grantedAuthorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                GrantedAuthority ga = grantedAuthorityArray[n2];
                result.add(ga.getAuthority());
                ++n2;
            }
            return result;
        }

        GrantedAuthority[] toGrantedAuthorities(List<String> roles) {
            GrantedAuthority[] authorities = new GrantedAuthority[roles.size()];
            int i = 0;
            while (i < authorities.length) {
                authorities[i] = new GrantedAuthorityImpl(roles.get(i));
                ++i;
            }
            return authorities;
        }
    }
}

