/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.security.impl.GeoserverUserDao;
import org.geoserver.web.wicket.SimpleChoiceRenderer;

public class RolesFormComponent
extends FormComponentPanel {
    List<String> roles = GeoserverUserDao.get().getRoles();
    List<String> choices;
    TextField newRoleField;
    Palette rolePalette;

    public RolesFormComponent(String id, IModel choiceModel, Form form, boolean hasAny) {
        super(id, choiceModel);
        if (hasAny) {
            this.roles.add(this.roles.size(), "*");
        }
        this.choices = new ArrayList<String>((List)choiceModel.getObject());
        this.rolePalette = this.rolesPalette((IModel)new PropertyModel((Object)this, "choices"));
        this.rolePalette.setOutputMarkupId(true);
        this.add(new Component[]{this.rolePalette});
        Component[] componentArray = new Component[1];
        this.newRoleField = new TextField("newRole", (IModel)new Model());
        componentArray[0] = this.newRoleField;
        this.add(componentArray);
        this.newRoleField.setOutputMarkupId(true);
        this.add(new Component[]{this.addRoleButton(form)});
    }

    Palette rolesPalette(IModel choiceModel) {
        return new Palette("roles", choiceModel, (IModel)new Model((Serializable)((Object)this.roles)), (IChoiceRenderer)new SimpleChoiceRenderer(), 10, false){

            protected Recorder newRecorderComponent() {
                Recorder rec = super.newRecorderComponent();
                rec.setRequired(true);
                return rec;
            }
        };
    }

    private AjaxButton addRoleButton(Form form) {
        AjaxButton button = new AjaxButton("addRole", form){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                String newRole = RolesFormComponent.this.newRoleField.getRawInput();
                if (!"*".equals(newRole)) {
                    RolesFormComponent.this.rolePalette.getRecorderComponent().validate();
                    RolesFormComponent.this.rolePalette.getRecorderComponent().updateModel();
                    RolesFormComponent.this.roles.add(newRole);
                    RolesFormComponent.this.choices.add(newRole);
                    RolesFormComponent.this.rolePalette.modelChanged();
                }
                RolesFormComponent.this.newRoleField.clearInput();
                target.addComponent((Component)RolesFormComponent.this.rolePalette);
                target.addComponent((Component)RolesFormComponent.this.newRoleField);
            }
        };
        button.setDefaultFormProcessing(false);
        return button;
    }

    protected void convertInput() {
        for (String role : this.choices) {
            if (!"*".equals(role)) continue;
            this.choices = new ArrayList<String>();
            this.choices.add("*");
        }
        this.setConvertedInput(this.choices);
    }

    public Palette getRolePalette() {
        return this.rolePalette;
    }
}

