/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.data;

import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.geoserver.security.AccessMode;
import org.geoserver.security.DataAccessRule;
import org.geoserver.security.DataAccessRuleDAO;
import org.geoserver.web.security.data.AbstractDataAccessRulePage;
import org.geoserver.web.security.data.DataAccessRulePage;
import org.geoserver.web.wicket.ParamResourceModel;

public class NewDataAccessRulePage
extends AbstractDataAccessRulePage {
    public NewDataAccessRulePage() {
        super(new DataAccessRule());
        this.form.add((IFormValidator)new DuplicateRuleValidator());
    }

    protected void onFormSubmit() {
        try {
            String roles = this.parseRole(this.rolesForComponent.getRolePalette().getModelObjectAsString());
            DataAccessRule rule = new DataAccessRule((String)this.workspace.getConvertedInput(), (String)this.layer.getConvertedInput(), (AccessMode)this.accessMode.getConvertedInput(), new String[]{roles});
            DataAccessRuleDAO dao = DataAccessRuleDAO.get();
            dao.addRule((Comparable)rule);
            dao.storeRules();
            this.setResponsePage(DataAccessRulePage.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred while saving user", e);
            this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}));
        }
    }

    private String parseRole(String modelObjectAsString) {
        return modelObjectAsString.substring(1, modelObjectAsString.length() - 1);
    }

    class DuplicateRuleValidator
    extends AbstractFormValidator {
        DuplicateRuleValidator() {
        }

        public void validate(Form form) {
            DataAccessRule rule = new DataAccessRule((String)NewDataAccessRulePage.this.workspace.getConvertedInput(), (String)NewDataAccessRulePage.this.layer.getConvertedInput(), (AccessMode)NewDataAccessRulePage.this.accessMode.getConvertedInput(), new String[]{NewDataAccessRulePage.this.rolesForComponent.getRolePalette().getModelObjectAsString()});
            if (DataAccessRuleDAO.get().getRules().contains(rule)) {
                form.error((Serializable)((Object)new ParamResourceModel("duplicateRule", (Component)NewDataAccessRulePage.this.getPage(), new Object[]{rule.getKey()}).getString()));
            }
        }

        public FormComponent[] getDependentFormComponents() {
            return new FormComponent[]{NewDataAccessRulePage.this.workspace, NewDataAccessRulePage.this.layer, NewDataAccessRulePage.this.accessMode, NewDataAccessRulePage.this.rolesForComponent};
        }
    }
}

