/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.user;

import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.wicket.Component;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.security.GeoserverUserDao;
import org.geoserver.web.security.user.AbstractUserPage;
import org.geoserver.web.security.user.UserPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class NewUserPage
extends AbstractUserPage {
    public NewUserPage() {
        super(new AbstractUserPage.UserUIModel());
        this.username.add((IValidator)new UserConflictValidator());
    }

    protected void onFormSubmit() {
        try {
            AbstractUserPage.UserUIModel user = (AbstractUserPage.UserUIModel)this.getModelObject();
            GeoserverUserDao dao = GeoserverUserDao.get();
            dao.putUser(user.toAcegiUser());
            dao.storeUsers();
            this.setResponsePage(UserPage.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred while saving user", e);
            this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}));
        }
    }

    class UserConflictValidator
    extends AbstractValidator {
        UserConflictValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String newName = (String)validatable.getValue();
            try {
                GeoserverUserDao.get().loadUserByUsername(newName);
                this.error(validatable, "NewUserPage.userConflict", Collections.singletonMap("user", newName));
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
                // empty catch block
            }
        }
    }
}

