/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.publish.LayerConfigurationPanel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.wms.web.publish.LegendGraphicAjaxUpdater;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StyleNameRenderer;
import org.geoserver.wms.web.publish.StylesModel;

public class WMSLayerConfig
extends LayerConfigurationPanel {
    public WMSLayerConfig(String id, IModel layerModel) {
        super(id, layerModel);
        StylesModel styles = new StylesModel();
        PropertyModel defaultStyleModel = new PropertyModel((Object)layerModel, "defaultStyle");
        DropDownChoice defaultStyle = new DropDownChoice("defaultStyle", (IModel)defaultStyleModel, (IModel)styles, (IChoiceRenderer)new StyleChoiceRenderer());
        defaultStyle.setRequired(true);
        this.add((Component)defaultStyle);
        Image defStyleImg = new Image("defaultStyleLegendGraphic");
        defStyleImg.setOutputMarkupId(true);
        this.add((Component)defStyleImg);
        String wmsURL = this.getRequest().getRelativePathPrefixToContextRoot();
        wmsURL = String.valueOf(wmsURL) + (wmsURL.endsWith("/") ? "wms?" : "/wms?");
        final LegendGraphicAjaxUpdater defaultStyleUpdater = new LegendGraphicAjaxUpdater(wmsURL, defStyleImg, (IModel)defaultStyleModel);
        defaultStyle.add((IBehavior)new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                defaultStyleUpdater.updateStyleImage(target);
            }
        });
        LiveCollectionModel stylesModel = LiveCollectionModel.set((IModel)new PropertyModel((Object)layerModel, "styles"));
        Palette extraStyles = new Palette("extraStyles", (IModel)stylesModel, (IModel)styles, new StyleNameRenderer(), 10, false){

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.availableHeader"));
            }
        };
        this.add((Component)extraStyles);
        this.add((Component)new TextField("wmsPath", (IModel)new PropertyModel((Object)layerModel, "path")));
    }
}

