/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data.publish;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.publish.StylesModel;
import org.geoserver.wms.web.publish.WMSLayerConfig;

public class WMSLayerConfigTest
extends GeoServerWicketTestSupport {
    public void testExisting() {
        final LayerInfo layer = this.getCatalog().getLayerByName(MockData.PONDS.getLocalPart());
        FormTestPage page = new FormTestPage(new ComponentBuilder(){

            public Component buildComponent(String id) {
                return new WMSLayerConfig(id, (IModel)new Model((Serializable)layer));
            }
        });
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:defaultStyle", DropDownChoice.class);
        StyleInfo target = (StyleInfo)((List)new StylesModel().getObject()).get(0);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:defaultStyle", 0);
        ft.submit();
        tester.assertModelValue("form:panel:defaultStyle", (Object)target);
    }

    public void testNew() {
        final LayerInfo layer = this.getCatalog().getFactory().createLayer();
        FormTestPage page = new FormTestPage(new ComponentBuilder(){

            public Component buildComponent(String id) {
                return new WMSLayerConfig(id, (IModel)new Model((Serializable)layer));
            }
        });
        Component layerConfig = page.get("form:panel:defaultStyle");
        tester.startPage((Page)page);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:defaultStyle", DropDownChoice.class);
        tester.submitForm("form");
        WMSLayerConfigTest.assertTrue((boolean)page.getSession().getFeedbackMessages().hasErrorMessageFor(layerConfig));
        page.getSession().getFeedbackMessages().clear();
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:defaultStyle", 0);
        ft.submit();
        WMSLayerConfigTest.assertFalse((boolean)page.getSession().getFeedbackMessages().hasErrorMessageFor(layerConfig));
    }
}

