/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.util.tester.FormTester;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.w3c.dom.Document;

public class StyleEditPageTest
extends GeoServerWicketTestSupport {
    StyleInfo buildingsStyle;

    protected void setUpInternal() throws Exception {
        this.login();
        this.buildingsStyle = this.getCatalog().getStyleByName(MockData.BUILDINGS.getLocalPart());
        StyleEditPage edit = new StyleEditPage(this.buildingsStyle);
        tester.startPage((Page)edit);
    }

    public void testLoad() throws Exception {
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("form:name", TextField.class);
        tester.assertComponent("form:SLD:editorContainer:editor", TextArea.class);
        tester.assertModelValue("form:name", (Object)"Buildings");
        File styleFile = GeoserverDataDirectory.findStyleFile((String)this.buildingsStyle.getFilename());
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d1 = db.parse(new FileInputStream(styleFile));
        String xml = tester.getComponentFromLastRenderedPage("form:SLD").getDefaultModelObjectAsString();
        xml = xml.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"");
        Document d2 = db.parse(new ByteArrayInputStream(xml.getBytes()));
        XMLAssert.assertXMLEqual((Document)d1, (Document)d2);
    }

    public void testMissingName() throws Exception {
        FormTester form = tester.newFormTester("form");
        form.setValue("name", "");
        form.submit();
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertErrorMessages(new String[]{"Field 'Name' is required."});
    }

    public void testChangeName() throws Exception {
        FormTester form = tester.newFormTester("form");
        form.setValue("name", "BuildingsNew");
        form.submit();
        StyleEditPageTest.assertNull((Object)this.getCatalog().getStyleByName("Buildings"));
        StyleEditPageTest.assertNotNull((Object)this.getCatalog().getStyleByName("BuildingsNew"));
    }
}

