/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.impl.AuthorityURL;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityURLListEditor
extends FormComponentPanel<List<AuthorityURLInfo>> {
    private static final long serialVersionUID = 5098470663723800345L;
    private ListView<AuthorityURLInfo> authorityURLs;
    private Label noMetadata;
    private WebMarkupContainer table;

    public AuthorityURLListEditor(String id, IModel<List<AuthorityURLInfo>> list) {
        super(id, list);
        Assert.notNull((Object)list.getObject());
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        container.add(new Component[]{this.table});
        this.authorityURLs = new ListView<AuthorityURLInfo>("authorities", new ArrayList((Collection)list.getObject())){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<AuthorityURLInfo> item) {
                item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd"))});
                TextField authName = new TextField("authName", (IModel)new PropertyModel((Object)item.getModel(), "name"));
                authName.setRequired(true);
                FormComponentFeedbackBorder authNameBorder = new FormComponentFeedbackBorder("authNameBorder");
                item.add(new Component[]{authNameBorder});
                authNameBorder.add(new Component[]{authName});
                TextField authURL = new TextField("authorityURL", (IModel)new PropertyModel((Object)item.getModel(), "href"));
                authURL.setRequired(true);
                authURL.add((IValidator)new UrlValidator());
                FormComponentFeedbackBorder urlBorder = new FormComponentFeedbackBorder("urlBorder");
                item.add(new Component[]{urlBorder});
                urlBorder.add(new Component[]{authURL});
                AjaxLink<Integer> link = new AjaxLink<Integer>("removeLink", (IModel)new Model((Serializable)Integer.valueOf(item.getIndex()))){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        ArrayList list = new ArrayList(AuthorityURLListEditor.this.authorityURLs.getModelObject());
                        int index = (Integer)this.getModelObject();
                        list.remove(index);
                        AuthorityURLListEditor.this.authorityURLs.setModelObject(list);
                        AuthorityURLListEditor.this.updateLinksVisibility();
                        target.addComponent((Component)container);
                    }
                };
                item.add(new Component[]{link});
            }
        };
        this.authorityURLs.setReuseItems(true);
        this.table.add(new Component[]{this.authorityURLs});
        this.noMetadata = new Label("noURLs", (IModel)new ResourceModel("noAuthorityURLsSoFar"));
        container.add(new Component[]{this.noMetadata});
        this.updateLinksVisibility();
        AjaxButton button = new AjaxButton("addURL"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                List list = AuthorityURLListEditor.this.authorityURLs.getModelObject();
                AuthorityURL authorityURL = new AuthorityURL();
                list.add(authorityURL);
                AuthorityURLListEditor.this.authorityURLs.setModelObject(list);
                AuthorityURLListEditor.this.convertInput();
                AuthorityURLListEditor.this.updateLinksVisibility();
                target.addComponent((Component)container);
            }
        };
        this.add(new Component[]{button});
    }

    private void updateLinksVisibility() {
        List list = this.authorityURLs.getModelObject();
        boolean anyLink = list.size() > 0;
        this.table.setVisible(anyLink);
        this.noMetadata.setVisible(!anyLink);
    }

    protected void convertInput() {
        List info = this.authorityURLs.getModelObject();
        if (info == null || info.size() == 0) {
            this.setConvertedInput(new ArrayList(2));
            return;
        }
        this.setConvertedInput(info);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }
}

