/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.web.WMSAdminPage;

public class WMSAdminPageTest
extends GeoServerWicketTestSupport {
    private WMSInfo wms;

    protected void setUpInternal() throws Exception {
        this.wms = (WMSInfo)this.getGeoServerApplication().getGeoServer().getService(WMSInfo.class);
        this.login();
    }

    public void testValues() throws Exception {
        tester.startPage(WMSAdminPage.class);
        tester.assertModelValue("form:keywords", (Object)this.wms.getKeywords());
        tester.assertModelValue("form:srs", new ArrayList());
    }

    public void testFormSubmit() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit("submit");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
    }

    public void testFormInvalid() throws Exception {
        tester.startPage(WMSAdminPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("srs", "bla");
        ft.submit("submit");
        List errors = tester.getMessages(400);
        WMSAdminPageTest.assertEquals((int)1, (int)errors.size());
        WMSAdminPageTest.assertTrue((boolean)((ValidationErrorFeedback)errors.get(0)).getMessage().contains("bla"));
        tester.assertRenderedPage(WMSAdminPage.class);
    }
}

