/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.HashMap;
import junit.framework.Test;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeFeatureTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new DescribeFeatureTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
    }

    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0");
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testPost() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" />";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testPostDummyFeature() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:TypeName>cgf:DummyFeature</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTest.assertEquals((String)"ServiceExceptionReport", (String)doc.getDocumentElement().getNodeName());
    }

    public void testWithoutExplicitMapping() throws Exception {
        String xml = "<DescribeFeatureType xmlns='http://www.opengis.net/wfs' xmlns:gml='http://www.opengis.net/gml' xmlns:ogc='http://www.opengis.net/ogc' version='1.0.0' service='WFS'> <TypeName>cdf:Locks</TypeName> </DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        DescribeFeatureTest.assertEquals((int)1, (int)doc.getElementsByTagName("xsd:complexType").getLength());
    }

    public void testWithoutTypeName() throws Exception {
        String[] expected;
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.0.0");
        NodeList nl = doc.getElementsByTagName("xsd:import");
        DescribeFeatureTest.assertEquals((int)3, (int)nl.getLength());
        HashMap imprts = new HashMap();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element imprt = (Element)nl.item(i);
            String namespace = imprt.getAttribute("namespace");
            String schemaLocation = imprt.getAttribute("schemaLocation");
            int query = schemaLocation.indexOf("?");
            schemaLocation = schemaLocation.substring(query + 1);
            String[] sp = schemaLocation.split("&");
            HashMap<String, String> params = new HashMap<String, String>();
            for (int j = 0; j < sp.length; ++j) {
                String[] sp1 = sp[j].split("=");
                params.put(sp1[0].toLowerCase(), sp1[1].toLowerCase());
            }
            imprts.put(namespace, params);
        }
        for (String namespace : expected = new String[]{MockData.SF_URI, MockData.CDF_URI, MockData.CGF_URI}) {
            DescribeFeatureTest.assertNotNull(imprts.get(namespace));
            HashMap params = (HashMap)imprts.get(namespace);
            DescribeFeatureTest.assertEquals((Object)"wfs", params.get("service"));
            DescribeFeatureTest.assertEquals((Object)"1.0.0", params.get("version"));
            DescribeFeatureTest.assertEquals((Object)"describefeaturetype", params.get("request"));
            String types = (String)params.get("typename");
            DescribeFeatureTest.assertNotNull((Object)types);
            Catalog cat = this.getCatalog();
            NamespaceInfo ns = cat.getNamespaceByURI(namespace);
            System.out.println(ns.getPrefix());
            DescribeFeatureTest.assertEquals((int)cat.getFeatureTypesByNamespace(ns).size(), (int)types.split("%2c").length);
        }
    }
}

