/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.EMFUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DeleteElementHandler
implements TransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    private WFSInfo wfs;
    FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);

    public DeleteElementHandler(GeoServer gs) {
        this.wfs = (WFSInfo)gs.getService(WFSInfo.class);
    }

    public Class getElementClass() {
        return DeleteElementType.class;
    }

    public QName[] getTypeNames(EObject element) throws WFSTransactionException {
        return new QName[]{((DeleteElementType)element).getTypeName()};
    }

    public void checkValidity(EObject element, Map featureTypeInfos) throws WFSTransactionException {
        if (!this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
            throw new WFSException("Transaction Delete support is not enabled");
        }
        DeleteElementType delete = (DeleteElementType)element;
        if (delete.getFilter() == null || Filter.INCLUDE.equals(delete.getFilter())) {
            throw new WFSTransactionException("Must specify filter for delete", "MissingParameterValue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(EObject element, TransactionType request, Map featureStores, TransactionResponseType response, TransactionListener listener) throws WFSTransactionException {
        long deleted;
        block10: {
            DeleteElementType delete = (DeleteElementType)element;
            QName elementName = delete.getTypeName();
            String handle = delete.getHandle();
            deleted = response.getTransactionSummary().getTotalDeleted().longValue();
            FeatureStore store = (FeatureStore)featureStores.get(elementName);
            if (store == null) {
                throw new WFSException("Could not locate FeatureStore for '" + elementName + "'");
            }
            String typeName = ((SimpleFeatureType)store.getSchema()).getTypeName();
            LOGGER.finer("Transaction Delete:" + element);
            try {
                Filter filter = delete.getFilter();
                CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(store.getSchema(), request.getVersion());
                filter = WFSReprojectionUtil.normalizeFilterCRS(filter, store.getSchema(), declaredCRS);
                TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_DELETE, elementName, (FeatureCollection<SimpleFeatureType, SimpleFeature>)store.getFeatures(filter));
                event.setSource(delete);
                listener.dataStoreChange(event);
                ReferencedEnvelope damaged = store.getBounds((Query)new DefaultQuery(delete.getTypeName().getLocalPart(), filter));
                if (damaged == null) {
                    damaged = store.getFeatures(filter).getBounds();
                }
                if (request.getLockId() != null && store instanceof FeatureLocking && request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                    FeatureLocking locking = (FeatureLocking)store;
                    DataStore data = (DataStore)store.getDataStore();
                    FeatureWriter writer = data.getFeatureWriter(typeName, filter, store.getTransaction());
                    try {
                        while (writer.hasNext()) {
                            String fid = ((SimpleFeature)writer.next()).getID();
                            HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
                            featureIds.add(this.factory.featureId(fid));
                            locking.unLockFeatures((Filter)this.factory.id(featureIds));
                            writer.remove();
                            ++deleted;
                        }
                        Object var23_26 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_27 = null;
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                    store.removeFeatures(filter);
                    break block10;
                }
                int deletedCount = store.getFeatures(filter).size();
                if (deletedCount > 0) {
                    deleted += (long)deletedCount;
                }
                store.removeFeatures(filter);
            }
            catch (IOException e) {
                String msg = e.getMessage();
                String eHandle = (String)EMFUtils.get((EObject)element, (String)"handle");
                String code = null;
                if (e instanceof FeatureLockException) {
                    code = "MissingParameterValue";
                }
                throw new WFSTransactionException(msg, e, code, eHandle, handle);
            }
        }
        response.getTransactionSummary().setTotalDeleted(BigInteger.valueOf(deleted));
    }
}

