/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.LockType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LockFeature {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    WFSInfo wfs;
    Catalog catalog;
    FilterFactory filterFactory;

    public LockFeature(WFSInfo wfs, Catalog catalog) {
        this(wfs, catalog, null);
    }

    public LockFeature(WFSInfo wfs, Catalog catalog, FilterFactory filterFactory) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.filterFactory = filterFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LockFeatureResponseType lockFeature(LockFeatureType request) throws WFSException {
        FeatureLock fLock = null;
        try {
            boolean lockAll;
            EList locks = request.getLock();
            if (locks == null || locks.isEmpty()) {
                String msg = "A LockFeature request must contain at least one LOCK element";
                throw new WFSException(msg);
            }
            LOGGER.info("locks size is " + locks.size());
            fLock = this.newFeatureLock(request);
            LockFeatureResponseType response = WfsFactory.eINSTANCE.createLockFeatureResponseType();
            response.setLockId(fLock.getAuthorization());
            response.setFeaturesLocked(WfsFactory.eINSTANCE.createFeaturesLockedType());
            response.setFeaturesNotLocked(WfsFactory.eINSTANCE.createFeaturesNotLockedType());
            int n = locks.size();
            for (int i = 0; i < n; ++i) {
                Object var24_27;
                int numberLocked;
                FeatureSource source;
                block30: {
                    Object var20_25;
                    FeatureCollection features;
                    FeatureTypeInfo meta;
                    LockType lock = (LockType)locks.get(i);
                    LOGGER.info("curLock is " + lock);
                    QName typeName = lock.getTypeName();
                    Filter filter = lock.getFilter();
                    if (filter == null) {
                        filter = Filter.INCLUDE;
                    }
                    try {
                        meta = this.catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
                        if (meta == null) {
                            throw new WFSException("Unknown feature type " + typeName.getPrefix() + ":" + typeName.getLocalPart());
                        }
                        source = meta.getFeatureSource(null, null);
                        CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(source.getSchema(), request.getVersion());
                        filter = WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), declaredCRS);
                        features = source.getFeatures(filter);
                        if (source instanceof FeatureLocking) {
                            ((FeatureLocking)source).setFeatureLock(fLock);
                        }
                    }
                    catch (IOException e) {
                        throw new WFSException(e);
                    }
                    Iterator reader = null;
                    numberLocked = -1;
                    try {
                        try {
                            reader = features.iterator();
                            while (reader.hasNext()) {
                                SimpleFeature feature = (SimpleFeature)reader.next();
                                FeatureId fid = this.fid(feature.getID());
                                Id fidFilter = this.fidFilter(fid);
                                if (!(source instanceof FeatureLocking)) {
                                    LOGGER.fine("Lock " + fid + " not supported by data store (authID:" + fLock.getAuthorization() + ")");
                                    response.getFeaturesNotLocked().getFeatureId().add((Object)fid);
                                    continue;
                                }
                                DefaultQuery query = new DefaultQuery(meta.getName(), (Filter)fidFilter, Integer.MAX_VALUE, Query.ALL_NAMES, lock.getHandle());
                                numberLocked = ((FeatureLocking)source).lockFeatures((Query)query);
                                if (numberLocked == 1) {
                                    LOGGER.fine("Lock " + fid + " (authID:" + fLock.getAuthorization() + ")");
                                    response.getFeaturesLocked().getFeatureId().add((Object)fid);
                                    continue;
                                }
                                if (numberLocked == 0) {
                                    LOGGER.fine("Lock " + fid + " conflict (authID:" + fLock.getAuthorization() + ")");
                                    response.getFeaturesNotLocked().getFeatureId().add((Object)fid);
                                    continue;
                                }
                                LOGGER.warning("Lock " + numberLocked + " " + fid + " (authID:" + fLock.getAuthorization() + ") duplicated FeatureID!");
                                response.getFeaturesLocked().getFeatureId().add((Object)fid);
                            }
                            var20_25 = null;
                            if (reader == null) break block30;
                        }
                        catch (IOException ioe) {
                            throw new WFSException(ioe);
                        }
                    }
                    catch (Throwable throwable) {
                        var20_25 = null;
                        if (reader == null) throw throwable;
                        features.close(reader);
                        throw throwable;
                    }
                    features.close(reader);
                }
                if (numberLocked <= 0) continue;
                DefaultTransaction t = new DefaultTransaction();
                try {
                    try {
                        Object var22_26;
                        try {
                            t.addAuthorization(response.getLockId());
                            DataStore dataStore = (DataStore)source.getDataStore();
                            dataStore.getLockingManager().refresh(response.getLockId(), (Transaction)t);
                            var22_26 = null;
                        }
                        catch (Throwable throwable) {
                            var22_26 = null;
                            t.commit();
                            throw throwable;
                        }
                        t.commit();
                        var24_27 = null;
                    }
                    catch (IOException e) {
                        throw new WFSException(e);
                    }
                }
                catch (Throwable throwable) {
                    var24_27 = null;
                    try {
                        t.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new WFSException(e);
                    }
                }
                try {}
                catch (IOException e) {
                    throw new WFSException(e);
                }
                t.close();
            }
            boolean bl = lockAll = request.getLockAction() != AllSomeType.SOME_LITERAL;
            if (lockAll && !response.getFeaturesNotLocked().getFeatureId().isEmpty()) {
                throw new WFSException("Could not aquire locks for:" + response.getFeaturesNotLocked());
            }
            if (response.getFeaturesLocked().getFeatureId().isEmpty()) {
                response.setFeaturesLocked(null);
            }
            if (!response.getFeaturesNotLocked().getFeatureId().isEmpty()) return response;
            response.setFeaturesNotLocked(null);
            return response;
        }
        catch (WFSException e) {
            if (fLock == null) throw e;
            try {
                this.release(fLock.getAuthorization());
                throw e;
            }
            catch (WFSException e1) {
                LOGGER.log(Level.SEVERE, "Error occured releasing locks", (Throwable)((Object)e1));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release(String lockId) throws WFSException {
        try {
            boolean refresh = false;
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                DefaultTransaction t;
                block12: {
                    LockingManager lockingManager;
                    DataAccess da;
                    DataStore dataStore = null;
                    if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                        dataStore = (DataStore)da;
                    }
                    if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null) continue;
                    t = new DefaultTransaction("Refresh " + meta.getWorkspace().getName());
                    t.addAuthorization(lockId);
                    if (!lockingManager.release(lockId, (Transaction)t)) break block12;
                    refresh = true;
                }
                Object var11_11 = null;
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
                continue;
                {
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                        var11_11 = null;
                        try {
                            t.close();
                        }
                        catch (IOException closeException) {
                            LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    try {
                        t.close();
                        throw throwable;
                    }
                    catch (IOException closeException) {
                        LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                    throw throwable;
                }
            }
            if (refresh) return;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public void releaseAll() throws WFSException {
        try {
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    dataStore = (DataStore)da;
                }
                if (dataStore != null && (lockingManager = dataStore.getLockingManager()) != null) continue;
            }
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public boolean exists(String lockId) throws WFSException {
        try {
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    dataStore = (DataStore)da;
                }
                if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null || !lockingManager.exists(lockId)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refresh(String lockId) throws WFSException {
        try {
            boolean refresh = false;
            List dataStores = this.catalog.getDataStores();
            for (DataStoreInfo meta : dataStores) {
                DefaultTransaction t;
                block12: {
                    LockingManager lockingManager;
                    DataAccess da;
                    DataStore dataStore = null;
                    if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                        dataStore = (DataStore)da;
                    }
                    if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null) continue;
                    t = new DefaultTransaction("Refresh " + meta.getWorkspace().getName());
                    t.addAuthorization(lockId);
                    if (!lockingManager.refresh(lockId, (Transaction)t)) break block12;
                    refresh = true;
                }
                Object var11_11 = null;
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
                continue;
                {
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                        var11_11 = null;
                        try {
                            t.close();
                        }
                        catch (IOException closeException) {
                            LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    try {
                        t.close();
                        throw throwable;
                    }
                    catch (IOException closeException) {
                        LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                    throw throwable;
                }
            }
            if (refresh) return;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    private FeatureId fid(String fid) {
        return this.filterFactory.featureId(fid);
    }

    private Id fidFilter(FeatureId fid) {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(fid);
        return this.filterFactory.id(ids);
    }

    protected FeatureLock newFeatureLock(LockFeatureType request) {
        int lockExpiry;
        if (request.getHandle() == null || request.getHandle().equals("")) {
            request.setHandle("GeoServer");
        }
        if (request.getExpiry() == null) {
            request.setExpiry(BigInteger.valueOf(0L));
        }
        if ((lockExpiry = request.getExpiry().intValue()) < 0) {
            return FeatureLockFactory.generate((String)request.getHandle(), (long)lockExpiry);
        }
        if (lockExpiry == 0) {
            return FeatureLockFactory.generate((String)request.getHandle(), (long)0L);
        }
        return FeatureLockFactory.generate((String)request.getHandle(), (long)(lockExpiry * 60 * 1000));
    }
}

