/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockFeatureTest
extends WFSTestSupport {
    public void testLockActionSomeAlreadyLocked() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        LockFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Lock>" + "</wfs:LockFeature>";
        dom = this.postAsDOM("wfs", xml);
        LockFeatureTest.assertEquals((String)"WFS_LockFeatureResponse", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  lockAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Lock>" + "</wfs:LockFeature>";
        dom = this.postAsDOM("wfs", xml);
        this.get("wfs?request=ReleaseLock&lockId=" + lockId);
        LockFeatureTest.assertEquals((String)"WFS_LockFeatureResponse", (String)dom.getDocumentElement().getNodeName());
        LockFeatureTest.assertFalse((dom.getElementsByTagName("FeaturesNotLocked").getLength() == 0 ? 1 : 0) != 0);
    }

    public void testDeleteWithoutLockId() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        LockFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Lock>" + "</wfs:LockFeature>";
        dom = this.postAsDOM("wfs", xml);
        LockFeatureTest.assertEquals((String)"WFS_LockFeatureResponse", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Delete typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Delete>" + "</wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        this.get("wfs?request=ReleaseLock&lockId=" + lockId);
        LockFeatureTest.assertTrue(("ServiceExceptionReport".equals(dom.getDocumentElement().getNodeName()) || dom.getElementsByTagName("wfs:FAILED").getLength() == 1 ? 1 : 0) != 0);
    }

    public void testUpdateWithLockId() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        LockFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Lock>" + "</wfs:LockFeature>";
        dom = this.postAsDOM("wfs", xml);
        LockFeatureTest.assertEquals((String)"WFS_LockFeatureResponse", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getElementsByTagName("LockId").item(0).getFirstChild().getNodeValue();
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"cdf:Locks\">" + "    <wfs:Property>" + "      <wfs:Name>cdf:id</wfs:Name>" + "      <wfs:Value>lfbt0002</wfs:Value>" + "    </wfs:Property>" + "    <ogc:Filter>" + "      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Update>" + "</wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        this.get("wfs?request=ReleaseLock&lockId=" + lockId);
        LockFeatureTest.assertFalse((dom.getElementsByTagName("wfs:SUCCESS").getLength() == 0 ? 1 : 0) != 0);
    }

    public void testWorkspaceQualified() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/wfs", xml);
        LockFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Lock>" + "</wfs:LockFeature>";
        dom = this.postAsDOM("cdf/wfs", xml);
        LockFeatureTest.assertEquals((String)"WFS_LockFeatureResponse", (String)dom.getDocumentElement().getNodeName());
    }

    public void testLayerQualified() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  outputFormat=\"GML2\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\" /></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/Locks/wfs", xml);
        LockFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:LockFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Lock typeName=\"Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid + "\"/>" + "    </ogc:Filter>" + "  </wfs:Lock>" + "</wfs:LockFeature>";
        dom = this.postAsDOM("cdf/Fifteen/wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)dom);
        dom = this.postAsDOM("cdf/Locks/wfs", xml);
        LockFeatureTest.assertEquals((String)"WFS_LockFeatureResponse", (String)dom.getDocumentElement().getNodeName());
    }
}

