/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.HashMap;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;

public class RetypingTransactionTest
extends WFSTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("alias", "MyPolygons");
        dataDirectory.addWellKnownType(MockData.POLYGONS, props);
        props.put("alias", "MyLines");
        dataDirectory.addWellKnownType(MockData.LINES, props);
        props.put("alias", "MyPoints");
        dataDirectory.addWellKnownType(MockData.POINTS, props);
    }

    public void testInsert() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:MyLines\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        RetypingTransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:featureMember").getLength());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:MyLines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:MyLines></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        RetypingTransactionTest.assertTrue((dom.getElementsByTagName("wfs:SUCCESS").getLength() != 0 ? 1 : 0) != 0);
        RetypingTransactionTest.assertTrue((dom.getElementsByTagName("wfs:InsertResult").getLength() != 0 ? 1 : 0) != 0);
        dom = this.postAsDOM("wfs", getFeature);
        RetypingTransactionTest.assertEquals((int)2, (int)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    public void testUpdate() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:MyPolygons\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        RetypingTransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:featureMember").getLength());
        RetypingTransactionTest.assertEquals((String)"t0002", (String)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:MyPolygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        dom = this.postAsDOM("wfs", getFeature);
        RetypingTransactionTest.assertEquals((String)"t0003", (String)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
    }

    public void testDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:MyPoints\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        RetypingTransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:featureMember").getLength());
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cgf:MyPoints\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cgf:id</ogc:PropertyName> <ogc:Literal>t0000</ogc:Literal> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        RetypingTransactionTest.assertEquals((String)"WFS_TransactionResponse", (String)dom.getDocumentElement().getLocalName());
        RetypingTransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        RetypingTransactionTest.assertEquals((int)0, (int)dom.getElementsByTagName("gml:featureMember").getLength());
    }
}

