/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSDescribeFeatureTypeOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geotools.gml.producer.FeatureTypeTransformer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;

public class XmlSchemaEncoder
extends WFSDescribeFeatureTypeOutputFormat {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses");
    private static final String SCHEMA_URI = "\"http://www.w3.org/2001/XMLSchema\"";
    private static final String XS_NAMESPACE = "\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";
    private static final String GML_URL = "\"http://www.opengis.net/gml\"";
    private static final String GML_NAMESPACE = "\n  xmlns:gml=\"http://www.opengis.net/gml\"";
    private static final String ELEMENT_FORM_DEFAULT = "\n  elementFormDefault=\"qualified\"";
    private static final String ATTR_FORM_DEFAULT = "\n  attributeFormDefault=\"unqualified\" version=\"1.0\">";
    private static final String TARGETNS_PREFIX = "\n  targetNamespace=\"";
    private static final String TARGETNS_SUFFIX = "\" ";
    private static final String FOOTER = "\n</xs:schema>";
    Catalog catalog;

    public XmlSchemaEncoder(GeoServer gs) {
        super(gs, "XMLSCHEMA");
        this.catalog = gs.getCatalog();
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    protected void write(FeatureTypeInfo[] featureTypeInfos, OutputStream output, Operation describeFeatureType) throws IOException {
        WFSInfo wfs = this.getInfo();
        String xmlResponse = this.generateTypes(featureTypeInfos, (DescribeFeatureTypeType)describeFeatureType.getParameters()[0]);
        if (!wfs.getGeoServer().getGlobal().isVerbose()) {
            xmlResponse = xmlResponse.replaceAll(">\n[ \\t\\n]*", ">");
            xmlResponse = xmlResponse.replaceAll("\n[ \\t\\n]*", " ");
        }
        OutputStreamWriter writer = new OutputStreamWriter(output, wfs.getGeoServer().getGlobal().getCharset());
        writer.write(xmlResponse);
        ((Writer)writer).flush();
    }

    private final String generateTypes(FeatureTypeInfo[] infos, DescribeFeatureTypeType request) throws IOException {
        StringBuffer tempResponse = new StringBuffer();
        tempResponse.append("<?xml version=\"1.0\" encoding=\"" + this.getInfo().getGeoServer().getGlobal().getCharset() + "\"?>" + "\n<xs:schema ");
        if (this.allSameType(infos)) {
            FeatureTypeInfo ftInfo = infos[0];
            String targetNs = ftInfo.getNamespace().getURI();
            tempResponse.append(TARGETNS_PREFIX + targetNs + TARGETNS_SUFFIX);
            tempResponse.append("\n  xmlns:" + ftInfo.getNamespace().getPrefix() + "=\"" + targetNs + "\"");
            tempResponse.append(GML_NAMESPACE);
            tempResponse.append(XS_NAMESPACE);
            tempResponse.append("\n  elementFormDefault=\"qualified\"\n  attributeFormDefault=\"unqualified\" version=\"1.0\">");
            tempResponse.append("\n\n<xs:import namespace=\"http://www.opengis.net/gml\" schemaLocation=\"" + ResponseUtils.buildSchemaURL((String)request.getBaseUrl(), (String)"gml/2.1.2.1/feature.xsd") + "\"/>\n\n");
            tempResponse.append(this.generateSpecifiedTypes(infos));
        } else {
            tempResponse.append(XS_NAMESPACE);
            tempResponse.append("\n  elementFormDefault=\"qualified\"\n  attributeFormDefault=\"unqualified\" version=\"1.0\">");
            HashSet<String> prefixes = new HashSet<String>();
            int i = 0;
            while (i < infos.length) {
                FeatureTypeInfo ftInfo = infos[i];
                prefixes.add(ftInfo.getNamespace().getPrefix());
                ++i;
            }
            Iterator prefixIter = prefixes.iterator();
            while (prefixIter.hasNext()) {
                String prefix = prefixIter.next().toString();
                tempResponse.append(this.getNSImport(prefix, infos, request.getBaseUrl(), request.getService().toLowerCase()));
            }
        }
        tempResponse.append(FOOTER);
        return tempResponse.toString();
    }

    private StringBuffer getNSImport(String prefix, FeatureTypeInfo[] infos, String baseUrl, String service) {
        LOGGER.finer("prefix is " + prefix);
        StringBuffer retBuffer = new StringBuffer("\n  <xs:import namespace=\"");
        String namespace = this.catalog.getNamespaceByPrefix(prefix).getURI();
        retBuffer.append(String.valueOf(namespace) + "\"");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("request", "DescribeFeatureType");
        params.put("service", "wfs");
        params.put("version", "1.0.0");
        StringBuilder typeNames = new StringBuilder();
        int i = 0;
        while (i < infos.length) {
            FeatureTypeInfo info = infos[i];
            String typeName = info.getPrefixedName();
            if (typeName.startsWith(String.valueOf(prefix) + ":")) {
                typeNames.append(typeName).append(",");
            }
            ++i;
        }
        typeNames.deleteCharAt(retBuffer.length() - 1);
        params.put("typeName", typeNames.toString());
        String ftLocation = ResponseUtils.buildURL((String)baseUrl, (String)service, params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        retBuffer.append("\n        schemaLocation=\"" + ResponseUtils.encodeXML((String)ftLocation));
        retBuffer.append("\"/>");
        return retBuffer;
    }

    private String generateSpecifiedTypes(FeatureTypeInfo[] infos) {
        String tempResponse = new String();
        String generatedType = new String();
        HashSet<FeatureTypeInfo> validTypes = new HashSet<FeatureTypeInfo>();
        int i = 0;
        while (i < infos.length) {
            FeatureTypeInfo ftInfo = infos[i];
            if (!validTypes.contains(ftInfo)) {
                File schemaFile = null;
                try {
                    if (schemaFile != null && schemaFile.exists() && schemaFile.canRead()) {
                        generatedType = this.writeFile(schemaFile);
                    } else {
                        FeatureType ft = ftInfo.getFeatureType();
                        String gType = this.generateFromSchema(ft);
                        if (gType != null && gType != "") {
                            generatedType = gType;
                        }
                    }
                }
                catch (IOException e) {
                    generatedType = "";
                }
                if (!generatedType.equals("")) {
                    tempResponse = String.valueOf(tempResponse) + generatedType;
                    validTypes.add(ftInfo);
                }
            }
            ++i;
        }
        Iterator i2 = validTypes.iterator();
        while (i2.hasNext()) {
            tempResponse = String.valueOf(tempResponse) + XmlSchemaEncoder.printElement((FeatureTypeInfo)i2.next());
        }
        tempResponse = String.valueOf(tempResponse) + "\n\n";
        return tempResponse;
    }

    private String generateFromSchema(FeatureType schema) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            FeatureTypeTransformer t = new FeatureTypeTransformer();
            t.setIndentation(4);
            t.setOmitXMLDeclaration(true);
            t.transform((Object)schema, (Writer)writer);
            return writer.getBuffer().toString();
        }
        catch (TransformerException te) {
            LOGGER.log(Level.WARNING, "Error generating schema from feature type", te);
            throw (IOException)new IOException("problem transforming type").initCause(te);
        }
    }

    private static String printElement(FeatureTypeInfo type) {
        return "\n  <xs:element name=\"" + type.getName() + "\" type=\"" + type.getNamespace().getPrefix() + ":" + type.getName() + "_Type" + "\" substitutionGroup=\"gml:_Feature\"/>";
    }

    public String writeFile(File inputFile) throws IOException {
        LOGGER.finest("writing file " + inputFile);
        String finalOutput = new String();
        try {
            int bytesRead;
            FileInputStream inputStream = new FileInputStream(inputFile);
            byte[] fileBuffer = new byte[inputStream.available()];
            while ((bytesRead = inputStream.read(fileBuffer)) != -1) {
                String tempOutput = new String(fileBuffer);
                finalOutput = String.valueOf(finalOutput) + tempOutput;
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("problem writing featureType information  from " + inputFile).initCause(e);
        }
        return finalOutput;
    }

    public boolean allSameType(FeatureTypeInfo[] infos) {
        boolean sameType = true;
        if (infos.length == 0) {
            return false;
        }
        FeatureTypeInfo first = infos[0];
        int i = 0;
        while (i < infos.length) {
            FeatureTypeInfo ftInfo = infos[i];
            if (!first.getNamespace().equals((Object)ftInfo.getNamespace())) {
                return false;
            }
            ++i;
        }
        return sameType;
    }
}

