/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.ActionType;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.TransactionPlugin;
import org.geoserver.wfs.TransactionPluginComparator;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.util.logging.Logging;
import org.geotools.xml.EMFUtils;
import org.opengis.filter.FilterFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;

public class Transaction {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    protected WFSInfo wfs;
    protected Catalog catalog;
    protected FilterFactory filterFactory;
    protected org.geotools.data.Transaction transaction;
    protected List transactionElementHandlers = new ArrayList();
    protected List transactionListeners = new ArrayList();
    protected List transactionPlugins = new ArrayList();

    public Transaction(WFSInfo wfs, Catalog catalog, ApplicationContext context) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.transactionElementHandlers.addAll(GeoServerExtensions.extensions(TransactionElementHandler.class));
        this.transactionListeners.addAll(GeoServerExtensions.extensions(TransactionListener.class));
        this.transactionPlugins.addAll(GeoServerExtensions.extensions(TransactionPlugin.class));
        this.transactionListeners.removeAll(this.transactionPlugins);
        Collections.sort(this.transactionPlugins, new TransactionPluginComparator());
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public TransactionResponseType transaction(TransactionType request) throws WFSException {
        if (!this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
            throw new WFSException("Transaction support is not enabled");
        }
        try {
            return this.execute(request);
        }
        catch (WFSException e) {
            this.abort(request);
            throw e;
        }
        catch (Throwable t) {
            this.abort(request);
            throw new WFSException(t);
        }
    }

    protected TransactionResponseType execute(TransactionType request) throws Exception {
        if (request.getReleaseAction() == null) {
            request.setReleaseAction(AllSomeType.ALL_LITERAL);
        }
        for (TransactionPlugin tp : this.transactionPlugins) {
            tp.beforeTransaction(request);
        }
        TransactionListenerMux multiplexer = new TransactionListenerMux();
        this.transaction = this.getDatastoreTransaction(request);
        HashMap<QName, FeatureStore> stores = new HashMap<QName, FeatureStore>();
        HashMap<String, FeatureSource> stores2 = new HashMap<String, FeatureSource>();
        Map elementHandlers = this.gatherElementHandlers(request.getGroup());
        for (Map.Entry entry : elementHandlers.entrySet()) {
            EObject element = (EObject)entry.getKey();
            TransactionElementHandler handler = (TransactionElementHandler)entry.getValue();
            HashMap<QName, FeatureTypeInfo> featureTypeInfos = new HashMap<QName, FeatureTypeInfo>();
            QName[] typeNames = handler.getTypeNames(element);
            int i = 0;
            while (i < typeNames.length) {
                QName typeName = typeNames[i];
                String name = typeName.getLocalPart();
                String namespaceURI = typeName.getNamespaceURI() != null ? typeName.getNamespaceURI() : this.catalog.getDefaultNamespace().getURI();
                LOGGER.fine("Locating FeatureSource uri:'" + namespaceURI + "' name:'" + name + "'");
                FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(namespaceURI, name);
                if (meta == null) {
                    String msg = "Feature type '" + name + "' is not available: ";
                    String handle = (String)EMFUtils.get((EObject)element, (String)"handle");
                    throw new WFSTransactionException(msg, null, handle);
                }
                featureTypeInfos.put(typeName, meta);
                ++i;
            }
            handler.checkValidity(element, featureTypeInfos);
            for (FeatureTypeInfo meta : featureTypeInfos.values()) {
                String msg;
                String typeRef = String.valueOf(meta.getStore().getName()) + ":" + meta.getName();
                String URI2 = meta.getNamespace().getURI();
                QName elementName = new QName(URI2, meta.getName(), meta.getNamespace().getPrefix());
                QName elementNameDefault = null;
                if (this.catalog.getDefaultNamespace().getURI().equals(URI2)) {
                    elementNameDefault = new QName(meta.getName());
                }
                LOGGER.fine("located FeatureType w/ typeRef '" + typeRef + "' and elementName '" + elementName + "'");
                if (stores.containsKey(elementName)) continue;
                try {
                    FeatureSource source = meta.getFeatureSource(null, null);
                    if (source instanceof FeatureStore) {
                        FeatureStore store = (FeatureStore)source;
                        store.setTransaction(this.transaction);
                        stores.put(elementName, (FeatureStore)source);
                        if (elementNameDefault != null) {
                            stores.put(elementNameDefault, (FeatureStore)source);
                        }
                        stores2.put(typeRef, source);
                        continue;
                    }
                    msg = elementName + " is read-only";
                    String handle = (String)EMFUtils.get((EObject)element, (String)"handle");
                    throw new WFSTransactionException(msg, null, handle);
                }
                catch (IOException ioException) {
                    msg = elementName + " is not available: " + ioException.getLocalizedMessage();
                    String handle = (String)EMFUtils.get((EObject)element, (String)"handle");
                    throw new WFSTransactionException(msg, ioException, handle);
                }
            }
        }
        String authorizationID = request.getLockId();
        if (authorizationID != null) {
            if (!this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                throw new WFSException("Lock support is not enabled");
            }
            LOGGER.finer("got lockId: " + authorizationID);
            if (!this.lockExists(authorizationID)) {
                String mesg = "Attempting to use a lockID that does not exist, it has either expired or was entered wrong.";
                throw new WFSException(mesg, "InvalidParameterValue");
            }
            try {
                this.transaction.addAuthorization(authorizationID);
            }
            catch (IOException ioException) {
                throw new WFSException("Authorization ID '" + authorizationID + "' not useable", ioException);
            }
        }
        TransactionResponseType result = WfsFactory.eINSTANCE.createTransactionResponseType();
        result.setTransactionResults(WfsFactory.eINSTANCE.createTransactionResultsType());
        result.getTransactionResults().setHandle(request.getHandle());
        result.setTransactionSummary(WfsFactory.eINSTANCE.createTransactionSummaryType());
        result.getTransactionSummary().setTotalInserted(BigInteger.valueOf(0L));
        result.getTransactionSummary().setTotalUpdated(BigInteger.valueOf(0L));
        result.getTransactionSummary().setTotalDeleted(BigInteger.valueOf(0L));
        result.setInsertResults(WfsFactory.eINSTANCE.createInsertResultsType());
        boolean exception = false;
        try {
            for (Map.Entry entry : elementHandlers.entrySet()) {
                EObject element = (EObject)entry.getKey();
                TransactionElementHandler handler = (TransactionElementHandler)entry.getValue();
                handler.execute(element, request, stores, result, multiplexer);
            }
        }
        catch (WFSTransactionException e) {
            exception = true;
            LOGGER.log(Level.SEVERE, "Transaction failed", (Throwable)((Object)e));
            ActionType action = WfsFactory.eINSTANCE.createActionType();
            if (e.getCode() != null) {
                action.setCode(e.getCode());
            } else {
                action.setCode("InvalidParameterValue");
            }
            action.setLocator(e.getLocator());
            action.setMessage(e.getMessage());
            result.getTransactionResults().getAction().add((Object)action);
        }
        boolean committed = false;
        try {
            if (exception) {
                this.transaction.rollback();
            } else {
                for (TransactionPlugin tp : this.transactionPlugins) {
                    tp.beforeCommit(request);
                }
                this.transaction.commit();
                committed = true;
                if (request.getLockId() != null) {
                    if (request.getReleaseAction() == AllSomeType.ALL_LITERAL) {
                        this.lockRelease(request.getLockId());
                    } else if (request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                        this.lockRefresh(request.getLockId());
                    }
                }
            }
        }
        finally {
            this.transaction.close();
            this.transaction = null;
        }
        for (TransactionPlugin tp : this.transactionPlugins) {
            tp.afterTransaction(request, (TransactionResponseType)(committed ? result : null), committed);
        }
        if (result.getInsertResults().getFeature().isEmpty()) {
            InsertedFeatureType insertedFeature = WfsFactory.eINSTANCE.createInsertedFeatureType();
            insertedFeature.getFeatureId().add((Object)this.filterFactory.featureId("none"));
            result.getInsertResults().getFeature().add((Object)insertedFeature);
        }
        return result;
    }

    private Map gatherElementHandlers(FeatureMap group) throws WFSTransactionException {
        LinkedHashMap<EObject, TransactionElementHandler> map = new LinkedHashMap<EObject, TransactionElementHandler>();
        for (FeatureMap.Entry entry : group) {
            EObject element = (EObject)entry.getValue();
            map.put(element, this.findElementHandler(element.getClass()));
        }
        return map;
    }

    protected final TransactionElementHandler findElementHandler(Class type) throws WFSTransactionException {
        ArrayList<TransactionElementHandler> matches = new ArrayList<TransactionElementHandler>();
        for (TransactionElementHandler handler : this.transactionElementHandlers) {
            if (!handler.getElementClass().isAssignableFrom(type)) continue;
            matches.add(handler);
        }
        if (matches.isEmpty()) {
            String msg = "No transaction element handler for : ( " + type + " )";
            throw new WFSTransactionException(msg);
        }
        if (matches.size() > 1) {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    TransactionElementHandler h1 = (TransactionElementHandler)o1;
                    TransactionElementHandler h2 = (TransactionElementHandler)o2;
                    if (h2.getElementClass().isAssignableFrom(h1.getElementClass())) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(matches, comparator);
        }
        return (TransactionElementHandler)matches.get(0);
    }

    protected DefaultTransaction getDatastoreTransaction(TransactionType request) throws IOException {
        Object principal;
        DefaultTransaction transaction = new DefaultTransaction();
        String username = "anonymous";
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (principal = authentication.getPrincipal()) instanceof UserDetails) {
            username = ((UserDetails)principal).getUsername();
        }
        transaction.putProperty((Object)"VersioningCommitAuthor", (Object)username);
        transaction.putProperty((Object)"VersioningCommitMessage", (Object)request.getHandle());
        return transaction;
    }

    public void abort(TransactionType request) {
        if (this.transaction == null) {
            return;
        }
        try {
            this.transaction.rollback();
            this.transaction.close();
        }
        catch (IOException ioException) {
            LOGGER.log(Level.SEVERE, "Failed trying to rollback a transaction:" + ioException);
        }
        if (request.getLockId() != null) {
            if (request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                try {
                    this.lockRefresh(request.getLockId());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured refreshing lock", e);
                }
            } else if (request.getReleaseAction() == AllSomeType.ALL_LITERAL) {
                try {
                    this.lockRelease(request.getLockId());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured releasing lock", e);
                }
            }
        }
    }

    void lockRelease(String lockId) throws WFSException {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.release(lockId);
    }

    private boolean lockExists(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        return lockFeature.exists(lockId);
    }

    private void lockRefresh(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.refresh(lockId);
    }

    private class TransactionListenerMux
    implements TransactionListener {
        private TransactionListenerMux() {
        }

        public void dataStoreChange(List listeners, TransactionEvent event) throws WFSException {
            for (TransactionListener listener : listeners) {
                listener.dataStoreChange(event);
            }
        }

        public void dataStoreChange(TransactionEvent event) throws WFSException {
            this.dataStoreChange(Transaction.this.transactionPlugins, event);
            this.dataStoreChange(Transaction.this.transactionListeners, event);
        }
    }
}

