/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BBoxKvpParser
extends KvpParser {
    public BBoxKvpParser() {
        super("bbox", Envelope.class);
    }

    public Object parse(String value) throws Exception {
        List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        if (unparsed.size() < 4) {
            throw new IllegalArgumentException("Requested bounding box contains wrongnumber of coordinates (should have 4): " + unparsed.size());
        }
        double[] bbox = new double[4];
        int i = 0;
        while (i < 4) {
            try {
                bbox[i] = Double.parseDouble((String)unparsed.get(i));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bounding box coordinate " + i + " is not parsable:" + unparsed.get(i));
            }
            ++i;
        }
        double minx = bbox[0];
        double miny = bbox[1];
        double maxx = bbox[2];
        double maxy = bbox[3];
        if (minx > maxx) {
            throw new ServiceException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx);
        }
        if (miny > maxy) {
            throw new ServiceException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy);
        }
        CoordinateReferenceSystem crs = null;
        if (unparsed.size() > 4) {
            StringBuilder sb = new StringBuilder();
            int i2 = 4;
            while (i2 < unparsed.size()) {
                sb.append(unparsed.get(i2));
                if (i2 < unparsed.size() - 1) {
                    sb.append(",");
                }
                ++i2;
            }
            crs = CRS.decode((String)sb.toString());
        }
        return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
    }
}

