/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import au.com.bytecode.opencsv.CSVReader;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.response.CSVOutputFormat;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVOutputFormatTest
extends WFSTestSupport {
    public void testFullRequest() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&typeName=sf:PrimitiveGeoFeature&outputFormat=csv");
        SimpleFeatureSource fs = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        CSVOutputFormatTest.assertEquals((String)"text/csv", (String)resp.getContentType());
        CSVOutputFormatTest.assertEquals((String)"attachment; filename=PrimitiveGeoFeature.csv", (String)resp.getHeader("Content-Disposition"));
        List<String[]> lines = this.readLines(resp.getOutputStreamContent());
        CSVOutputFormatTest.assertEquals((int)(fs.getCount(Query.ALL) + 1), (int)lines.size());
        for (String[] line : lines) {
            CSVOutputFormatTest.assertEquals((int)(fs.getSchema().getDescriptors().size() + 1), (int)line.length);
        }
    }

    public void testEscapes() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.setName("funnyLabels");
        SimpleFeatureType type = builder.buildFeatureType();
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.0)), "A label with \"quotes\""}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 4.0)), "A long label\nwith newlines"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f1);
        data.addFeature(f2);
        SimpleFeatureSource fs = data.getFeatureSource("funnyLabels");
        GetFeatureType gft = WfsFactory.eINSTANCE.createGetFeatureType();
        Operation op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{gft});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fs.getFeatures());
        CSVOutputFormat format = new CSVOutputFormat(this.getGeoServer());
        format.write(fct, (OutputStream)bos, op);
        List<String[]> lines = this.readLines(bos.toString());
        CSVOutputFormatTest.assertEquals((int)(fs.getCount(Query.ALL) + 1), (int)lines.size());
        for (String[] line : lines) {
            CSVOutputFormatTest.assertEquals((int)(((SimpleFeatureType)fs.getSchema()).getAttributeCount() + 1), (int)line.length);
        }
        CSVOutputFormatTest.assertEquals((Object)f1.getAttribute("label"), (Object)lines.get(1)[2]);
        CSVOutputFormatTest.assertEquals((Object)f2.getAttribute("label"), (Object)lines.get(2)[2]);
    }

    private List<String[]> readLines(String csvContent) throws IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new StringReader(csvContent));
        ArrayList<String[]> result = new ArrayList<String[]>();
        while ((nextLine = reader.readNext()) != null) {
            result.add(nextLine);
        }
        return result;
    }
}

