/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeFeatureTypeTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new DescribeFeatureTypeTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
    }

    public void testDateMappings() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"" + MockData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "\">" + " <wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        NodeList elements = doc.getElementsByTagName("xsd:element");
        boolean date = false;
        boolean dateTime = false;
        for (int i = 0; i < elements.getLength(); ++i) {
            Element e = (Element)elements.item(i);
            if ("dateProperty".equals(e.getAttribute("name"))) {
                date = "xsd:date".equals(e.getAttribute("type"));
            }
            if (!"dateTimeProperty".equals(e.getAttribute("name"))) continue;
            dateTime = "xsd:dateTime".equals(e.getAttribute("type"));
        }
        DescribeFeatureTypeTest.assertTrue((boolean)date);
        DescribeFeatureTypeTest.assertTrue((boolean)dateTime);
    }

    public void testNoNamespaceDeclaration() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }
}

