/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.GetFeatureWithLockType;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.LockType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs.XlinkPropertyNameType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.FeatureBoundsFeatureCollection;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.filter.expression.AbstractExpressionVisitor;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.EMFUtils;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GetFeature {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests");
    protected Catalog catalog;
    protected WFSInfo wfs;
    protected FilterFactory filterFactory;

    public GetFeature(WFSInfo wfs, Catalog catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public WFSInfo getWFS() {
        return this.wfs;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public FeatureCollectionType run(GetFeatureType request) throws WFSException {
        EList queries = request.getQuery();
        if (queries.isEmpty()) {
            throw new WFSException("No query specified");
        }
        if (EMFUtils.isUnset((List)queries, (String)"typeName")) {
            String msg = "No feature types specified";
            throw new WFSException(msg);
        }
        if (request.getMaxFeatures() == null) {
            request.setMaxFeatures(BigInteger.valueOf(Integer.MAX_VALUE));
        }
        int maxFeatures = Math.min(request.getMaxFeatures().intValue(), this.wfs.getMaxFeatures());
        int count = 0;
        ArrayList<FeatureCollection<? extends FeatureType, ? extends Feature>> results = new ArrayList<FeatureCollection<? extends FeatureType, ? extends Feature>>();
        try {
            for (int i = 0; i < request.getQuery().size() && count < maxFeatures; ++i) {
                QueryType query = (QueryType)request.getQuery().get(i);
                FeatureTypeInfo meta = null;
                if (query.getTypeName().size() == 1) {
                    meta = this.featureTypeInfo((QName)query.getTypeName().get(0));
                }
                FeatureSource source = meta.getFeatureSource(null, null);
                List atts = meta.getAttributes();
                ArrayList<String> attNames = new ArrayList<String>(atts.size());
                for (AttributeTypeInfo att : atts) {
                    attNames.add(att.getName());
                }
                EList propNames = query.getPropertyName();
                for (String propName : propNames) {
                    if (propName.indexOf(58) != -1) {
                        propName = propName.substring(propName.indexOf(58) + 1);
                    }
                    if (attNames.contains(propName)) continue;
                    String mesg = "Requested property: " + propName + " is " + "not available " + "for " + query.getTypeName() + ".  " + "The possible propertyName " + "values are: " + attNames;
                    throw new WFSException(mesg);
                }
                ArrayList<String> extraGeometries = new ArrayList<String>();
                ArrayList<String> properties = new ArrayList<String>();
                if (propNames.size() != 0) {
                    for (AttributeTypeInfo ati : atts) {
                        LOGGER.finer("checking to see if " + propNames + " contains" + ati);
                        if (ati.getMinOccurs() > 0 && ati.getMaxOccurs() != 0) {
                            properties.add(ati.getName());
                            continue;
                        }
                        for (String propName : propNames) {
                            if (!propName.matches("(\\w+:)?" + ati.getName())) continue;
                            properties.add(ati.getName());
                            break;
                        }
                        if (!this.wfs.isFeatureBounding() || !(meta.getFeatureType().getDescriptor(ati.getName()) instanceof GeometryDescriptor) || properties.contains(ati.getName())) continue;
                        properties.add(ati.getName());
                        extraGeometries.add(ati.getName());
                    }
                    query.getPropertyName().clear();
                    query.getPropertyName().addAll(properties);
                }
                if (query.getFilter() != null && source.getSchema() instanceof SimpleFeatureType) {
                    final FeatureType featureType = source.getSchema();
                    AbstractExpressionVisitor visitor = new AbstractExpressionVisitor(){

                        public Object visit(PropertyName name, Object data) {
                            if (name.evaluate((Object)featureType) == null) {
                                throw new WFSException("Illegal property name: " + name.getPropertyName(), "InvalidParameterValue");
                            }
                            return name;
                        }
                    };
                    query.getFilter().accept((FilterVisitor)new AbstractFilterVisitor((ExpressionVisitor)visitor), null);
                    AbstractFilterVisitor fvisitor = new AbstractFilterVisitor(){

                        protected Object visit(BinarySpatialOperator filter, Object data) {
                            AttributeDescriptor att;
                            PropertyName name = null;
                            if (filter.getExpression1() instanceof PropertyName) {
                                name = (PropertyName)filter.getExpression1();
                            } else if (filter.getExpression2() instanceof PropertyName) {
                                name = (PropertyName)filter.getExpression2();
                            }
                            if (name != null && !((att = (AttributeDescriptor)name.evaluate((Object)featureType)) instanceof GeometryDescriptor)) {
                                throw new WFSException("Property " + name + " is not geometric", "InvalidParameterValue");
                            }
                            return filter;
                        }
                    };
                    query.getFilter().accept((FilterVisitor)fvisitor, null);
                    if (this.wfs.isCiteCompliant() && query.getSrsName() != null) {
                        final QueryType fquery = query;
                        fvisitor = new AbstractFilterVisitor(){

                            public Object visit(BBOX filter, Object data) {
                                if (filter.getSRS() != null && !fquery.getSrsName().toString().equals(filter.getSRS())) {
                                    DefaultGeographicCRS geo = DefaultGeographicCRS.WGS84;
                                    GeneralEnvelope e = new GeneralEnvelope(new double[]{filter.getMinX(), filter.getMinY()}, new double[]{filter.getMaxX(), filter.getMaxY()});
                                    CoordinateReferenceSystem crs = null;
                                    try {
                                        crs = CRS.decode((String)filter.getSRS());
                                        e = CRS.transform((MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)geo, (boolean)true), (Envelope)e);
                                    }
                                    catch (Exception ex) {
                                        throw new WFSException(ex);
                                    }
                                    try {
                                        crs = CRS.decode((String)fquery.getSrsName().toString());
                                    }
                                    catch (Exception ex) {
                                        throw new WFSException(ex);
                                    }
                                    GeographicBoundingBox valid = (GeographicBoundingBox)crs.getDomainOfValidity().getGeographicElements().iterator().next();
                                    if (e.getMinimum(0) < valid.getWestBoundLongitude() || e.getMinimum(0) > valid.getEastBoundLongitude() || e.getMaximum(0) < valid.getWestBoundLongitude() || e.getMaximum(0) > valid.getEastBoundLongitude() || e.getMinimum(1) < valid.getSouthBoundLatitude() || e.getMinimum(1) > valid.getNorthBoundLatitude() || e.getMaximum(1) < valid.getSouthBoundLatitude() || e.getMaximum(1) > valid.getNorthBoundLatitude()) {
                                        throw new WFSException("bounding box out of valid range of crs", "InvalidParameterValue");
                                    }
                                }
                                return data;
                            }
                        };
                        query.getFilter().accept((FilterVisitor)fvisitor, null);
                    }
                }
                int queryMaxFeatures = maxFeatures - count;
                if (meta.getMaxFeatures() > 0 && meta.getMaxFeatures() < queryMaxFeatures) {
                    queryMaxFeatures = meta.getMaxFeatures();
                }
                Query gtQuery = this.toDataQuery(query, queryMaxFeatures, (FeatureSource<? extends FeatureType, ? extends Feature>)source, request);
                LOGGER.fine("Query is " + query + "\n To gt2: " + gtQuery);
                Object features = this.getFeatures(request, (FeatureSource<? extends FeatureType, ? extends Feature>)source, gtQuery);
                if (!"1.0".equals(request.getVersion()) && !"1.0.0".equals(request.getVersion()) || request.getQuery().size() != 1 && maxFeatures != Integer.MAX_VALUE) {
                    count += features.size();
                }
                if (features.getSchema() instanceof SimpleFeatureType && extraGeometries.size() > 0) {
                    ArrayList residualProperties = new ArrayList(properties);
                    residualProperties.removeAll(extraGeometries);
                    String[] residualNames = residualProperties.toArray(new String[residualProperties.size()]);
                    SimpleFeatureType targetType = DataUtilities.createSubType((SimpleFeatureType)((SimpleFeatureType)features.getSchema()), (String[])residualNames);
                    features = new FeatureBoundsFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)features, targetType);
                }
                results.add((FeatureCollection<? extends FeatureType, ? extends Feature>)features);
            }
        }
        catch (IOException e) {
            throw new WFSException("Error occurred getting features", e, request.getHandle());
        }
        catch (SchemaException e) {
            throw new WFSException("Error occurred getting features", e, request.getHandle());
        }
        String lockId = null;
        if (request instanceof GetFeatureWithLockType) {
            GetFeatureWithLockType withLockRequest = (GetFeatureWithLockType)request;
            LockFeatureType lockRequest = WfsFactory.eINSTANCE.createLockFeatureType();
            lockRequest.setExpiry(withLockRequest.getExpiry());
            lockRequest.setHandle(withLockRequest.getHandle());
            lockRequest.setLockAction(AllSomeType.ALL_LITERAL);
            for (int i = 0; i < request.getQuery().size(); ++i) {
                QueryType query = (QueryType)request.getQuery().get(i);
                LockType lock = WfsFactory.eINSTANCE.createLockType();
                lock.setFilter(query.getFilter());
                lock.setHandle(query.getHandle());
                lock.setTypeName((QName)query.getTypeName().get(0));
                lockRequest.getLock().add((Object)lock);
            }
            LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
            lockFeature.setFilterFactory(this.filterFactory);
            LockFeatureResponseType response = lockFeature.lockFeature(lockRequest);
            lockId = response.getLockId();
        }
        return this.buildResults(count, results, lockId);
    }

    protected FeatureCollectionType buildResults(int count, List results, String lockId) {
        FeatureCollectionType result = WfsFactory.eINSTANCE.createFeatureCollectionType();
        result.setNumberOfFeatures(BigInteger.valueOf(count));
        result.setTimeStamp(Calendar.getInstance());
        result.setLockId(lockId);
        result.getFeature().addAll((Collection)results);
        return result;
    }

    protected FeatureCollection<? extends FeatureType, ? extends Feature> getFeatures(GetFeatureType request, FeatureSource<? extends FeatureType, ? extends Feature> source, Query gtQuery) throws IOException {
        return source.getFeatures(gtQuery);
    }

    public Query toDataQuery(QueryType query, int maxFeatures, FeatureSource<? extends FeatureType, ? extends Feature> source, GetFeatureType request) throws WFSException {
        Iterator x;
        CoordinateReferenceSystem target;
        Filter filter;
        String wfsVersion = request.getVersion();
        if (maxFeatures <= 0) {
            maxFeatures = Integer.MAX_VALUE;
        }
        String[] props = null;
        if (!query.getPropertyName().isEmpty()) {
            props = new String[query.getPropertyName().size()];
            for (int p = 0; p < query.getPropertyName().size(); ++p) {
                String propertyName;
                props[p] = propertyName = (String)query.getPropertyName().get(p);
            }
        }
        if ((filter = query.getFilter()) == null) {
            filter = Filter.INCLUDE;
        }
        CoordinateReferenceSystem crs = source.getSchema().getCoordinateReferenceSystem();
        CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(crs, wfsVersion);
        Filter transformedFilter = filter;
        if (declaredCRS != null) {
            transformedFilter = WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), declaredCRS);
        }
        QName typeName = (QName)query.getTypeName().get(0);
        DefaultQuery dataQuery = new DefaultQuery(typeName.getLocalPart(), transformedFilter, maxFeatures, props, query.getHandle());
        if (query.getSrsName() != null) {
            try {
                target = CRS.decode((String)query.getSrsName().toString());
            }
            catch (Exception e) {
                String msg = "Unable to support srsName: " + query.getSrsName();
                throw new WFSException(msg, e);
            }
        } else {
            target = declaredCRS;
        }
        if (target != null && declaredCRS != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)target)) {
            dataQuery.setCoordinateSystemReproject(target);
        }
        if (query.getSortBy() != null) {
            EList sortBy = query.getSortBy();
            dataQuery.setSortBy(sortBy.toArray(new SortBy[sortBy.size()]));
        }
        if (query.getFeatureVersion() != null) {
            dataQuery.setVersion(query.getFeatureVersion());
        }
        Hints hints = new Hints();
        if (request.getTraverseXlinkDepth() != null) {
            Integer traverseXlinkDepth = GetFeature.traverseXlinkDepth(request.getTraverseXlinkDepth());
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)traverseXlinkDepth);
        }
        if (!query.getXlinkPropertyName().isEmpty() && (x = query.getXlinkPropertyName().iterator()).hasNext()) {
            XlinkPropertyNameType xlinkProperty = (XlinkPropertyNameType)x.next();
            Integer traverseXlinkDepth = GetFeature.traverseXlinkDepth(xlinkProperty.getTraverseXlinkDepth());
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)traverseXlinkDepth);
            PropertyName xlinkPropertyName = this.filterFactory.property(xlinkProperty.getValue());
            hints.put((Object)Hints.ASSOCIATION_PROPERTY, (Object)xlinkPropertyName);
            dataQuery.setHints(hints);
        }
        hints.put((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        dataQuery.setHints(hints);
        return dataQuery;
    }

    static Integer traverseXlinkDepth(String raw) {
        Integer traverseXlinkDepth = null;
        try {
            traverseXlinkDepth = new Integer(raw);
        }
        catch (NumberFormatException nfe) {
            if ("*".equals(raw)) {
                traverseXlinkDepth = new Integer(2);
            }
            throw nfe;
        }
        return traverseXlinkDepth;
    }

    FeatureTypeInfo featureTypeInfo(QName name) throws WFSException, IOException {
        FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(name.getNamespaceURI(), name.getLocalPart());
        if (meta == null) {
            String msg = "Could not locate " + name + " in catalog.";
            throw new WFSException(msg);
        }
        return meta;
    }
}

