/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.ows.xml.v1_0.OWSConfiguration;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.PropertyTypePropertyExtractor;
import org.geoserver.wfs.xml.WFSHandlerFactory;
import org.geoserver.wfs.xml.XSQNameBinding;
import org.geoserver.wfs.xml.filter.v1_1.FilterTypeBinding;
import org.geoserver.wfs.xml.filter.v1_1.PropertyNameTypeBinding;
import org.geoserver.wfs.xml.gml3.AbstractGeometryTypeBinding;
import org.geoserver.wfs.xml.gml3.CircleTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.ActionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.AllSomeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.BaseRequestTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.Base_TypeNameListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.DeleteElementTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.DescribeFeatureTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureCollectionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureReferenceTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureTypeListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeaturesLockedTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeaturesNotLockedTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GMLObjectTypeListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GMLObjectTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetCapabilitiesTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetFeatureWithLockTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetGmlObjectTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.IdentifierGenerationOptionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.InsertElementTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.InsertResultTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.InsertedFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.LockFeatureResponseTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.LockFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.LockTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.MetadataURLTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.NativeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.OperationTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.OperationsTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.OutputFormatListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.PropertyTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.QueryTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.ResultTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionResponseTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionResultsTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionSummaryTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TypeNameListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.UpdateElementTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFS_CapabilitiesTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.XlinkPropertyNameBinding;
import org.geoserver.wfs.xml.xs.DateBinding;
import org.geotools.filter.v1_0.OGCBBOXTypeBinding;
import org.geotools.filter.v1_1.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.SubstitutionGroupXSAnyTypeBinding;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.OptionalComponentParameter;
import org.geotools.xml.Schemas;
import org.geotools.xml.XSD;
import org.geotools.xs.XS;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.SetterInjectionComponentAdapter;

public class WFSConfiguration
extends Configuration {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    protected Catalog catalog;
    protected FeatureTypeSchemaBuilder schemaBuilder;

    public WFSConfiguration(Catalog catalog, FeatureTypeSchemaBuilder schemaBuilder, final WFS wfs) {
        super((XSD)wfs);
        this.catalog = catalog;
        this.schemaBuilder = schemaBuilder;
        catalog.addListener(new CatalogListener(){

            public void handleAddEvent(CatalogAddEvent event) {
                if (event.getSource() instanceof FeatureTypeInfo) {
                    this.reloaded();
                }
            }

            public void handleModifyEvent(CatalogModifyEvent event) {
                if (event.getSource() instanceof DataStoreInfo || event.getSource() instanceof FeatureTypeInfo || event.getSource() instanceof NamespaceInfo) {
                    this.reloaded();
                }
            }

            public void handlePostModifyEvent(CatalogPostModifyEvent event) {
            }

            public void handleRemoveEvent(CatalogRemoveEvent event) {
            }

            public void reloaded() {
                wfs.flush();
            }
        });
        this.addDependency((Configuration)new OGCConfiguration());
        this.addDependency((Configuration)new GMLConfiguration());
        this.addDependency((Configuration)new OWSConfiguration());
    }

    protected void registerBindings(MutablePicoContainer container) {
        container.registerComponentImplementation((Object)WFS.ACTIONTYPE, ActionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.ALLSOMETYPE, AllSomeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.BASE_TYPENAMELISTTYPE, Base_TypeNameListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.BASEREQUESTTYPE, BaseRequestTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.DELETEELEMENTTYPE, DeleteElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.DESCRIBEFEATURETYPETYPE, DescribeFeatureTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURECOLLECTIONTYPE, FeatureCollectionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURESLOCKEDTYPE, FeaturesLockedTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURESNOTLOCKEDTYPE, FeaturesNotLockedTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURETYPELISTTYPE, FeatureTypeListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURETYPETYPE, FeatureTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETCAPABILITIESTYPE, GetCapabilitiesTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETFEATURETYPE, GetFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETFEATUREWITHLOCKTYPE, GetFeatureWithLockTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETGMLOBJECTTYPE, GetGmlObjectTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GMLOBJECTTYPELISTTYPE, GMLObjectTypeListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GMLOBJECTTYPETYPE, GMLObjectTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.IDENTIFIERGENERATIONOPTIONTYPE, IdentifierGenerationOptionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTEDFEATURETYPE, InsertedFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTELEMENTTYPE, InsertElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTRESULTSTYPE, InsertResultTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKFEATURERESPONSETYPE, LockFeatureResponseTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKFEATURETYPE, LockFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKTYPE, LockTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.METADATAURLTYPE, MetadataURLTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.NATIVETYPE, NativeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.OPERATIONSTYPE, OperationsTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.OPERATIONTYPE, OperationTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.OUTPUTFORMATLISTTYPE, OutputFormatListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.PROPERTYTYPE, PropertyTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.QUERYTYPE, QueryTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.RESULTTYPETYPE, ResultTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONRESPONSETYPE, TransactionResponseTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONRESULTSTYPE, TransactionResultsTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONSUMMARYTYPE, TransactionSummaryTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONTYPE, TransactionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TYPENAMELISTTYPE, TypeNameListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.UPDATEELEMENTTYPE, UpdateElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.WFS_CAPABILITIESTYPE, WFS_CapabilitiesTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.XLINKPROPERTYNAME, XlinkPropertyNameBinding.class);
        container.registerComponentImplementation((Object)FeatureReferenceTypeBinding.FeatureReferenceType, FeatureReferenceTypeBinding.class);
        Schemas.unregisterComponent((PicoContainer)container, (Object)XS.ANYTYPE);
        container.registerComponentImplementation((Object)XS.ANYTYPE, SubstitutionGroupXSAnyTypeBinding.class);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void addDependency(Configuration dependency) {
        super.addDependency(dependency);
    }

    protected void configureContext(MutablePicoContainer context) {
        super.configureContext(context);
        context.registerComponentInstance((Object)WfsFactory.eINSTANCE);
        context.registerComponentInstance((Object)new WFSHandlerFactory(this.catalog, this.schemaBuilder));
        context.registerComponentInstance((Object)this.catalog);
        context.registerComponentImplementation(PropertyTypePropertyExtractor.class);
        FeatureTypeCache featureTypeCache = (FeatureTypeCache)context.getComponentInstanceOfType(FeatureTypeCache.class);
        List featureTypes = this.catalog.getFeatureTypes();
        for (FeatureTypeInfo meta : featureTypes) {
            if (!meta.enabled()) continue;
            FeatureType featureType = null;
            try {
                featureType = meta.getFeatureType();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not load underlying feature type for type " + meta.getName(), e);
                continue;
            }
            featureTypeCache.put(featureType);
        }
    }

    protected void configureBindings(Map bindings) {
        bindings.put(XS.DATE, DateBinding.class);
        bindings.put(OGC.FilterType, FilterTypeBinding.class);
        bindings.put(OGC.PropertyNameType, PropertyNameTypeBinding.class);
        bindings.put(GML.CircleType, CircleTypeBinding.class);
        bindings.put(GML.AbstractGeometryType, new SetterInjectionComponentAdapter((Object)GML.AbstractGeometryType, AbstractGeometryTypeBinding.class, new Parameter[]{new OptionalComponentParameter(CoordinateReferenceSystem.class)}));
        bindings.put(OGC.BBOXType, new SetterInjectionComponentAdapter((Object)OGC.BBOXType, OGCBBOXTypeBinding.class, new Parameter[]{new OptionalComponentParameter(CoordinateReferenceSystem.class)}));
        bindings.put(XS.QNAME, XSQNameBinding.class);
    }
}

