/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.wfs.BaseRequestType;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class GML3OutputFormat
extends WFSGetFeatureOutputFormat {
    WFSInfo wfs;
    Catalog catalog;
    GeoServerInfo global;
    WFSConfiguration configuration;

    public GML3OutputFormat(GeoServer geoServer, WFSConfiguration configuration) {
        super(new HashSet<Object>(Arrays.asList("gml3", "text/xml; subtype=gml/3.1.1")));
        this.wfs = (WFSInfo)geoServer.getService(WFSInfo.class);
        this.catalog = geoServer.getCatalog();
        this.global = geoServer.getGlobal();
        this.configuration = configuration;
    }

    @Override
    public String getMimeType(Object value, Operation operation) {
        return "text/xml; subtype=gml/3.1.1";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "GML3";
    }

    @Override
    protected void write(FeatureCollectionType results, OutputStream output, Operation getFeature) throws ServiceException, IOException {
        EList featureCollections = results.getFeature();
        HashMap<String, HashSet<FeatureTypeInfo>> ns2metas = new HashMap<String, HashSet<FeatureTypeInfo>>();
        for (int fcIndex = 0; fcIndex < featureCollections.size(); ++fcIndex) {
            if (getFeature.getParameters()[0] instanceof GetFeatureType) {
                GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])getFeature.getParameters(), GetFeatureType.class);
                QueryType queryType = (QueryType)request.getQuery().get(fcIndex);
                for (QName name : queryType.getTypeName()) {
                    NameImpl featureTypeName = new NameImpl(name.getNamespaceURI(), name.getLocalPart());
                    FeatureTypeInfo meta = this.catalog.getFeatureTypeByName((Name)featureTypeName);
                    if (meta == null) {
                        throw new WFSException("Could not find feature type " + featureTypeName + " in the GeoServer catalog");
                    }
                    HashSet<FeatureTypeInfo> metas = (HashSet<FeatureTypeInfo>)ns2metas.get(featureTypeName.getNamespaceURI());
                    if (metas == null) {
                        metas = new HashSet<FeatureTypeInfo>();
                        ns2metas.put(featureTypeName.getNamespaceURI(), metas);
                    }
                    metas.add(meta);
                }
                continue;
            }
            FeatureType featureType = ((FeatureCollection)featureCollections.get(fcIndex)).getSchema();
            String namespaceURI = featureType.getName().getNamespaceURI();
            FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(featureType.getName());
            if (meta == null) {
                throw new WFSException("Could not find feature type " + featureType.getName() + " in the GeoServer catalog");
            }
            HashSet<FeatureTypeInfo> metas = (HashSet<FeatureTypeInfo>)ns2metas.get(namespaceURI);
            if (metas == null) {
                metas = new HashSet<FeatureTypeInfo>();
                ns2metas.put(namespaceURI, metas);
            }
            metas.add(meta);
        }
        if (this.wfs.isFeatureBounding()) {
            this.configuration.getProperties().remove(GMLConfiguration.NO_FEATURE_BOUNDS);
        } else {
            this.configuration.getProperties().add(GMLConfiguration.NO_FEATURE_BOUNDS);
        }
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        encoder.setEncoding(Charset.forName(this.global.getCharset()));
        BaseRequestType gft = (BaseRequestType)getFeature.getParameters()[0];
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.buildSchemaURL((String)gft.getBaseUrl(), (String)"wfs/1.1.0/wfs.xsd"));
        Map params = ResponseUtils.params((String[])new String[]{"service", "WFS", "version", "1.1.0", "request", "DescribeFeatureType"});
        for (Map.Entry entry : ns2metas.entrySet()) {
            String namespaceURI = (String)entry.getKey();
            Set metas = (Set)entry.getValue();
            StringBuffer typeNames = new StringBuffer();
            Iterator m = metas.iterator();
            while (m.hasNext()) {
                FeatureTypeInfo meta = (FeatureTypeInfo)m.next();
                typeNames.append(meta.getPrefixedName());
                if (!m.hasNext()) continue;
                typeNames.append(",");
            }
            params.put("typeName", typeNames.toString());
            encoder.setSchemaLocation(namespaceURI, ResponseUtils.buildURL((String)gft.getBaseUrl(), (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE));
        }
        encoder.encode((Object)results, WFS.FEATURECOLLECTION, output);
    }
}

