/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransactionTest
extends WFSTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addPropertiesType(new QName(MockData.SF_URI, "WithGMLProperties", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("WithGMLProperties.properties"), Collections.EMPTY_MAP);
    }

    public void testInsert1() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\"><wfs:Insert handle=\"insert-1\"> <sf:PrimitiveGeoFeature gml:id=\"cite.gmlsf0-f01\">  <gml:description>Fusce tellus ante, tempus nonummy, ornare sed, accumsan nec, leo.Vivamus pulvinar molestie nisl.</gml:description><gml:name>Aliquam condimentum felis sit amet est.</gml:name><sf:curveProperty>  <gml:LineString gml:id=\"cite.gmlsf0-g01\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\">   <gml:posList>47.608284 19.034142 51.286873 16.7836 49.849854 15.764992</gml:posList> </gml:LineString></sf:curveProperty><sf:intProperty>1025</sf:intProperty><sf:measurand>7.405E2</sf:measurand><sf:dateTimeProperty>2006-06-23T12:43:12+01:00</sf:dateTimeProperty><sf:decimalProperty>90.62</sf:decimalProperty></sf:PrimitiveGeoFeature></wfs:Insert><wfs:Insert handle=\"insert-2\"><sf:AggregateGeoFeature gml:id=\"cite.gmlsf0-f02\"> <gml:description>Duis nulla nisi, molestie vel, rhoncus a, ullamcorper eu, justo. Sed bibendum. Ut sem. Mauris nec nunc a eros aliquet pharetra. Mauris nonummy, pede et tincidunt ultrices, mauris lectus fermentum massa, in ullamcorper lectusfelis vitae metus. Sed imperdiet sollicitudin dolor. </gml:description> <gml:name codeSpace=\"http://cite.opengeospatial.org/gmlsf\">cite.gmlsf0-f02</gml:name> <gml:name>Quisqu\u00e9 viverra</gml:name> <gml:boundedBy>   <gml:Envelope srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\">     <gml:lowerCorner>36.1 8.0</gml:lowerCorner>    <gml:upperCorner>52.0 21.1</gml:upperCorner>   </gml:Envelope>  </gml:boundedBy>   <sf:multiPointProperty><gml:MultiPoint srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"><gml:pointMember> <gml:Point><gml:pos>49.325176 21.036873</gml:pos></gml:Point></gml:pointMember><gml:pointMember>  <gml:Point><gml:pos>36.142586 13.56189</gml:pos></gml:Point></gml:pointMember><gml:pointMember>  <gml:Point><gml:pos>51.920937 8.014193</gml:pos></gml:Point></gml:pointMember></gml:MultiPoint></sf:multiPointProperty><sf:doubleProperty>2012.78</sf:doubleProperty>  <sf:intRangeProperty>43</sf:intRangeProperty> <sf:strProperty>Donec ligul\u00e4 pede, sodales i\u0144, vehicula eu, sodales et, l\u00eao.</sf:strProperty><sf:featureCode>AK121</sf:featureCode></sf:AggregateGeoFeature></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        TransactionTest.assertTrue((dom.getElementsByTagName("ogc:FeatureId").getLength() > 0 ? 1 : 0) != 0);
    }

    public void testInsertWithNoSRS() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Points\"> <wfs:PropertyName>cite:id</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        int n = dom.getElementsByTagName("cgf:Points").getLength();
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Points><cgf:pointProperty><gml:Point><gml:pos>20 40</gml:pos></gml:Point></cgf:pointProperty><cgf:id>t0002</cgf:id></cgf:Points></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        NodeList numberInserteds = dom.getElementsByTagName("wfs:totalInserted");
        Element numberInserted = (Element)numberInserteds.item(0);
        TransactionTest.assertNotNull((Object)numberInserted);
        TransactionTest.assertEquals((String)"1", (String)numberInserted.getFirstChild().getNodeValue());
        String fid = this.getFirstElementByTagName(dom, "ogc:FeatureId").getAttribute("fid");
        dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((int)(n + 1), (int)dom.getElementsByTagName("cgf:Points").getLength());
        getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Points\"> <ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>cgf:id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Query> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((String)"20.0 40.0", (String)this.getFirstElementByTagName(dom, "gml:pos").getFirstChild().getNodeValue());
    }

    public void testInsertWithSRS() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Points\"/> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        int n = dom.getElementsByTagName("cgf:Points").getLength();
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert srsName=\"EPSG:32615\"> <cgf:Points><cgf:pointProperty><gml:Point><gml:pos>1 1</gml:pos></gml:Point></cgf:pointProperty><cgf:id>t0003</cgf:id></cgf:Points></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        NodeList numberInserteds = dom.getElementsByTagName("wfs:totalInserted");
        Element numberInserted = (Element)numberInserteds.item(0);
        TransactionTest.assertNotNull((Object)numberInserted);
        TransactionTest.assertEquals((String)"1", (String)numberInserted.getFirstChild().getNodeValue());
        getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Points\"> </wfs:Query> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", getFeature);
        NodeList pointsList = dom.getElementsByTagName("cgf:Points");
        TransactionTest.assertEquals((int)(n + 1), (int)pointsList.getLength());
    }

    public void testInsertWithGMLProperties() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:gml=\"http://www.opengis.net/gml\"><wfs:Insert><sf:WithGMLProperties><gml:location><gml:Point><gml:coordinates>2,2</gml:coordinates></gml:Point></gml:location><gml:name>two</gml:name><sf:foo>2</sf:foo></sf:WithGMLProperties></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        Element inserted = this.getFirstElementByTagName(dom, "wfs:totalInserted");
        TransactionTest.assertEquals((String)"1", (String)inserted.getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:WithGMLProperties");
        NodeList features = dom.getElementsByTagName("sf:WithGMLProperties");
        TransactionTest.assertEquals((int)2, (int)features.getLength());
        Element feature = (Element)features.item(1);
        TransactionTest.assertEquals((String)"two", (String)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        TransactionTest.assertEquals((String)"2", (String)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        Element location = this.getFirstElementByTagName(feature, "gml:location");
        Element pos = this.getFirstElementByTagName(location, "gml:pos");
        TransactionTest.assertEquals((String)"2.0 2.0", (String)pos.getFirstChild().getNodeValue());
        xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:gml=\"http://www.opengis.net/gml\"><wfs:Insert><sf:WithGMLProperties><sf:location><gml:Point><gml:coordinates>3,3</gml:coordinates></gml:Point></sf:location><sf:name>three</sf:name><sf:foo>3</sf:foo></sf:WithGMLProperties></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:WithGMLProperties");
        features = dom.getElementsByTagName("sf:WithGMLProperties");
        TransactionTest.assertEquals((int)3, (int)features.getLength());
        feature = (Element)features.item(2);
        TransactionTest.assertEquals((String)"three", (String)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        TransactionTest.assertEquals((String)"3", (String)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        location = this.getFirstElementByTagName(feature, "gml:location");
        pos = this.getFirstElementByTagName(location, "gml:pos");
        TransactionTest.assertEquals((String)"3.0 3.0", (String)pos.getFirstChild().getNodeValue());
    }

    public void testUpdateWithGMLProperties() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Update typeName=\"sf:WithGMLProperties\">   <wfs:Property>     <wfs:Name>gml:name</wfs:Name>     <wfs:Value>two</wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:Name>gml:location</wfs:Name>     <wfs:Value>        <gml:Point>          <gml:coordinates>2,2</gml:coordinates>        </gml:Point>     </wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:Name>sf:foo</wfs:Name>     <wfs:Value>2</wfs:Value>   </wfs:Property>   <ogc:Filter>     <ogc:PropertyIsEqualTo>       <ogc:PropertyName>foo</ogc:PropertyName>       <ogc:Literal>1</ogc:Literal>     </ogc:PropertyIsEqualTo>   </ogc:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        Element updated = this.getFirstElementByTagName(dom, "wfs:totalUpdated");
        TransactionTest.assertEquals((String)"1", (String)updated.getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:WithGMLProperties");
        NodeList features = dom.getElementsByTagName("sf:WithGMLProperties");
        TransactionTest.assertEquals((int)1, (int)features.getLength());
        Element feature = (Element)features.item(0);
        TransactionTest.assertEquals((String)"two", (String)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        TransactionTest.assertEquals((String)"2", (String)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        Element location = this.getFirstElementByTagName(feature, "gml:location");
        Element pos = this.getFirstElementByTagName(location, "gml:pos");
        TransactionTest.assertEquals((String)"2.0 2.0", (String)pos.getFirstChild().getNodeValue());
        xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Update typeName=\"sf:WithGMLProperties\">   <wfs:Property>     <wfs:Name>sf:name</wfs:Name>     <wfs:Value>trhee</wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:Name>sf:location</wfs:Name>     <wfs:Value>        <gml:Point>          <gml:coordinates>3,3</gml:coordinates>        </gml:Point>     </wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:Name>sf:foo</wfs:Name>     <wfs:Value>3</wfs:Value>   </wfs:Property>   <ogc:Filter>     <ogc:PropertyIsEqualTo>       <ogc:PropertyName>foo</ogc:PropertyName>       <ogc:Literal>2</ogc:Literal>     </ogc:PropertyIsEqualTo>   </ogc:Filter> </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        updated = this.getFirstElementByTagName(dom, "wfs:totalUpdated");
        TransactionTest.assertEquals((String)"1", (String)updated.getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:WithGMLProperties");
        features = dom.getElementsByTagName("sf:WithGMLProperties");
        TransactionTest.assertEquals((int)1, (int)features.getLength());
        feature = (Element)features.item(0);
        TransactionTest.assertEquals((String)"trhee", (String)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        TransactionTest.assertEquals((String)"3", (String)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        location = this.getFirstElementByTagName(feature, "gml:location");
        pos = this.getFirstElementByTagName(location, "gml:pos");
        TransactionTest.assertEquals((String)"3.0 3.0", (String)pos.getFirstChild().getNodeValue());
    }

    public void testInsertWithBoundedBy() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:BasicPolygons> <gml:boundedBy>  <gml:Envelope><gml:lowerCorner>-1.0 2.0</gml:lowerCorner><gml:upperCorner>2.0 5.0</gml:upperCorner>  </gml:Envelope> </gml:boundedBy>  <cite:the_geom>    <gml:MultiPolygon>      <gml:polygonMember>         <gml:Polygon><gml:exterior><gml:LinearRing><gml:posList>-1.0 5.0 2.0 5.0 2.0 2.0 -1.0 2.0 -1.0 5.0</gml:posList></gml:LinearRing></gml:exterior>         </gml:Polygon>      </gml:polygonMember>    </gml:MultiPolygon>  </cite:the_geom>  <cite:ID>foo</cite:ID> </cite:BasicPolygons></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        this.print(dom);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        TransactionTest.assertEquals((String)"1", (String)this.getFirstElementByTagName(dom, "wfs:totalInserted").getFirstChild().getNodeValue());
        TransactionTest.assertTrue((dom.getElementsByTagName("ogc:FeatureId").getLength() > 0 ? 1 : 0) != 0);
    }

    public void testInsert2() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:RoadSegments>  <cite:the_geom><gml:MultiLineString xmlns:gml=\"http://www.opengis.net/gml\"    srsName=\"EPSG:4326\"> <gml:lineStringMember>                  <gml:LineString>                   <gml:posList>4.2582 52.0643 4.2584 52.0648</gml:posList>                 </gml:LineString>               </gml:lineStringMember>             </gml:MultiLineString>  </cite:the_geom>  <cite:FID>foo</cite:FID>  <cite:NAME>bar</cite:NAME> </cite:RoadSegments></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        TransactionTest.assertEquals((String)"1", (String)this.getFirstElementByTagName(dom, "wfs:totalInserted").getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?request=getfeature&typename=cite:RoadSegments&srsName=EPSG:4326&cql_filter=FID%3D'foo'");
        TransactionTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("cite:RoadSegments").getLength());
        Element roadSegment = this.getFirstElementByTagName(dom, "cite:RoadSegments");
        Element posList = this.getFirstElementByTagName(roadSegment, "gml:posList");
        String[] pos = posList.getFirstChild().getTextContent().split(" ");
        TransactionTest.assertEquals((int)4, (int)pos.length);
        TransactionTest.assertEquals((double)4.2582, (double)Double.parseDouble(pos[0]), (double)1.0E-4);
        TransactionTest.assertEquals((double)52.0643, (double)Double.parseDouble(pos[1]), (double)1.0E-4);
        TransactionTest.assertEquals((double)4.2584, (double)Double.parseDouble(pos[2]), (double)1.0E-4);
        TransactionTest.assertEquals((double)52.0648, (double)Double.parseDouble(pos[3]), (double)1.0E-4);
    }

    public void testUpdateForcedSRS() throws Exception {
        this.testUpdate("srsName=\"EPSG:4326\"");
    }

    public void testUpdateNoSRS() throws Exception {
        this.testUpdate("");
    }

    private void testUpdate(String srs) throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Update typeName=\"cite:RoadSegments\">   <wfs:Property>     <wfs:Name>cite:the_geom</wfs:Name>     <wfs:Value>      <gml:MultiLineString xmlns:gml=\"http://www.opengis.net/gml\" " + srs + ">" + "       <gml:lineStringMember>" + "         <gml:LineString>" + "            <gml:posList>4.2582 52.0643 4.2584 52.0648</gml:posList>" + "         </gml:LineString>" + "       </gml:lineStringMember>" + "      </gml:MultiLineString>" + "     </wfs:Value>" + "   </wfs:Property>" + "   <ogc:Filter>" + "     <ogc:PropertyIsEqualTo>" + "       <ogc:PropertyName>FID</ogc:PropertyName>" + "       <ogc:Literal>102</ogc:Literal>" + "     </ogc:PropertyIsEqualTo>" + "   </ogc:Filter>" + " </wfs:Update>" + "</wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        TransactionTest.assertEquals((String)"1", (String)this.getFirstElementByTagName(dom, "wfs:totalUpdated").getFirstChild().getNodeValue());
        String srsBlock = "".equals(srs) ? "" : "&" + srs.replaceAll("\"", "");
        dom = this.getAsDOM("wfs?request=getfeature&typename=cite:RoadSegments" + srsBlock + "&" + "cql_filter=FID%3D'102'");
        TransactionTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("cite:RoadSegments").getLength());
        Element roadSegment = this.getFirstElementByTagName(dom, "cite:RoadSegments");
        Element posList = this.getFirstElementByTagName(roadSegment, "gml:posList");
        String[] pos = posList.getFirstChild().getTextContent().split(" ");
        TransactionTest.assertEquals((int)4, (int)pos.length);
        TransactionTest.assertEquals((double)4.2582, (double)Double.parseDouble(pos[0]), (double)1.0E-4);
        TransactionTest.assertEquals((double)52.0643, (double)Double.parseDouble(pos[1]), (double)1.0E-4);
        TransactionTest.assertEquals((double)4.2584, (double)Double.parseDouble(pos[2]), (double)1.0E-4);
        TransactionTest.assertEquals((double)52.0648, (double)Double.parseDouble(pos[3]), (double)1.0E-4);
    }

    public void testUpdateWithInvalidProperty() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Update typeName=\"cite:RoadSegments\">   <wfs:Property>     <wfs:Name>INVALID</wfs:Name>     <wfs:Value>INVALID</wfs:Value>   </wfs:Property>   <ogc:Filter>     <ogc:PropertyIsEqualTo>       <ogc:PropertyName>FID</ogc:PropertyName>       <ogc:Literal>102</ogc:Literal>     </ogc:PropertyIsEqualTo>   </ogc:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
    }
}

