/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.io.IOException;
import java.io.OutputStream;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSDescribeFeatureTypeOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.w3c.dom.Element;

public class XmlSchemaEncoder
extends WFSDescribeFeatureTypeOutputFormat {
    WFSInfo wfs;
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;
    FeatureTypeSchemaBuilder schemaBuilder;

    public XmlSchemaEncoder(String mimeType, GeoServer gs, FeatureTypeSchemaBuilder schemaBuilder) {
        super(mimeType);
        this.wfs = (WFSInfo)gs.getService(WFSInfo.class);
        this.catalog = gs.getCatalog();
        this.resourceLoader = this.catalog.getResourceLoader();
        this.schemaBuilder = schemaBuilder;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return this.getOutputFormat();
    }

    protected void write(FeatureTypeInfo[] featureTypeInfos, OutputStream output, Operation describeFeatureType) throws IOException {
        GeoServerInfo global = this.wfs.getGeoServer().getGlobal();
        DescribeFeatureTypeType req = (DescribeFeatureTypeType)describeFeatureType.getParameters()[0];
        XSDSchema schema = this.schemaBuilder.build(featureTypeInfos, req.getBaseUrl());
        schema.updateElement();
        String encoding = global.getCharset();
        XSDResourceImpl.serialize((OutputStream)output, (Element)schema.getElement(), (String)encoding);
    }

    public static class V10
    extends XmlSchemaEncoder {
        public V10(GeoServer gs) {
            super("XMLSCHEMA", gs, new FeatureTypeSchemaBuilder.GML2(gs));
        }

        public String getMimeType(Object arg0, Operation arg1) throws ServiceException {
            return "text/xml";
        }
    }

    public static class V11
    extends XmlSchemaEncoder {
        public V11(GeoServer gs) {
            super("text/xml; subtype=gml/3.1.1", gs, new FeatureTypeSchemaBuilder.GML3(gs));
        }
    }
}

