/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.w3c.dom.Document;

public class GML3FeatureProducerTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GML3FeatureProducerTest());
    }

    GML3OutputFormat producer() {
        FeatureTypeSchemaBuilder.GML3 sb = new FeatureTypeSchemaBuilder.GML3(this.getGeoServer());
        WFSConfiguration configuration = new WFSConfiguration(this.getCatalog(), (FeatureTypeSchemaBuilder)sb, new WFS((FeatureTypeSchemaBuilder)sb));
        return new GML3OutputFormat(this.getGeoServer(), configuration);
    }

    Operation request(QName ... names) {
        Service service = this.getServiceDescriptor10();
        GetFeatureType type = WfsFactory.eINSTANCE.createGetFeatureType();
        type.setBaseUrl("http://localhost:8080/geoserver");
        for (QName name : names) {
            QueryType queryType = WfsFactory.eINSTANCE.createQueryType();
            queryType.setTypeName(Collections.singletonList(name));
            type.getQuery().add((Object)queryType);
        }
        Operation request = new Operation("wfs", service, null, new Object[]{type});
        return request;
    }

    public void testSingle() throws Exception {
        FeatureSource source = this.getFeatureSource(MockData.SEVEN);
        FeatureCollection features = source.getFeatures();
        FeatureCollectionType fcType = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fcType.getFeature().add((Object)features);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.producer().write(fcType, (OutputStream)output, this.request(MockData.SEVEN));
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        GML3FeatureProducerTest.assertEquals((int)7, (int)document.getElementsByTagName("cdf:Seven").getLength());
    }

    public void testMultipleSameNamespace() throws Exception {
        FeatureCollectionType fcType = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fcType.getFeature().add((Object)this.getFeatureSource(MockData.SEVEN).getFeatures());
        fcType.getFeature().add((Object)this.getFeatureSource(MockData.FIFTEEN).getFeatures());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.producer().write(fcType, (OutputStream)output, this.request(MockData.SEVEN, MockData.FIFTEEN));
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        GML3FeatureProducerTest.assertEquals((int)22, (int)(document.getElementsByTagName("cdf:Seven").getLength() + document.getElementsByTagName("cdf:Fifteen").getLength()));
    }

    public void testMultipleDifferentNamespace() throws Exception {
        FeatureCollectionType fcType = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fcType.getFeature().add((Object)this.getFeatureSource(MockData.SEVEN).getFeatures());
        fcType.getFeature().add((Object)this.getFeatureSource(MockData.POLYGONS).getFeatures());
        int npolys = this.getFeatureSource(MockData.POLYGONS).getFeatures().size();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.producer().write(fcType, (OutputStream)output, this.request(MockData.SEVEN, MockData.POLYGONS));
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        GML3FeatureProducerTest.assertEquals((int)(7 + npolys), (int)(document.getElementsByTagName("cdf:Seven").getLength() + document.getElementsByTagName("cgf:Polygons").getLength()));
    }
}

