/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.data.FeatureSource;
import org.geotools.map.FeatureSourceMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WMSTestSupport
extends GeoServerTestSupport {
    protected WMS getWMS() {
        return new WMS(this.getGeoServer());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("default", MockData.class.getResource("Default.sld"));
    }

    protected MapLayer createMapLayer(QName layerName) throws IOException {
        return this.createMapLayer(layerName, null);
    }

    protected MapLayer createMapLayer(QName layerName, String styleName) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo info = catalog.getFeatureTypeByName(layerName.getNamespaceURI(), layerName.getLocalPart());
        LayerInfo layerInfo = catalog.getLayerByName(layerName.getLocalPart());
        Style style = layerInfo.getDefaultStyle().getStyle();
        if (styleName != null) {
            style = catalog.getStyleByName(styleName).getStyle();
        }
        FeatureSource featureSource = info.getFeatureSource(null, null);
        FeatureSourceMapLayer layer = new FeatureSourceMapLayer(featureSource, style);
        layer.setTitle(layer.getTitle());
        return layer;
    }

    protected GetMapRequest createGetMapRequest(QName layerName) {
        return this.createGetMapRequest(new QName[]{layerName});
    }

    protected GetMapRequest createGetMapRequest(QName[] layerNames) {
        GetMapRequest request = new GetMapRequest(this.getWMS());
        request.setHttpServletRequest((HttpServletRequest)this.createRequest("wms"));
        MapLayerInfo[] layers = new MapLayerInfo[layerNames.length];
        ArrayList<Style> styles = new ArrayList<Style>();
        for (int i = 0; i < layerNames.length; ++i) {
            LayerInfo layerInfo = this.getCatalog().getLayerByName(layerNames[i].getLocalPart());
            try {
                styles.add(layerInfo.getDefaultStyle().getStyle());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            layers[i] = new MapLayerInfo(layerInfo);
        }
        request.setLayers(layers);
        request.setStyles(styles);
        request.setBbox(new Envelope(-180.0, -90.0, 180.0, 90.0));
        request.setCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        request.setSRS("EPSG:4326");
        request.setRawKvp(new HashMap());
        return request;
    }

    protected void assertNotBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getRGB(x, y) == bgColor.getRGB()) continue;
                ++pixelsDiffer;
            }
        }
        LOGGER.info(testName + ": pixel count=" + image.getWidth() * image.getHeight() + " non bg pixels: " + pixelsDiffer);
        WMSTestSupport.assertTrue((String)(testName + " image is comlpetely blank"), (0 < pixelsDiffer ? 1 : 0) != 0);
    }

    public static Document transform(Object req, TransformerBase tr) throws Exception {
        return WMSTestSupport.transform(req, tr, true);
    }

    public static Document transform(Object req, TransformerBase tr, boolean namespaceAware) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        tr.transform(req, (OutputStream)out);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaceAware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        class EmptyResolver
        implements EntityResolver {
            EmptyResolver() {
            }

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                InputSource source = new InputSource(reader);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
        }
        db.setEntityResolver(new EmptyResolver());
        Document doc = db.parse(new ByteArrayInputStream(out.toByteArray()));
        return doc;
    }
}

