/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.mockrunner.mock.web.MockHttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfoImpl;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerKvpRequestReader;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeLayerKvpRequestReaderTest
extends TestCase {
    private GeoServerImpl geoServerImpl;
    private WMS wms;
    private MockHttpServletRequest request;
    private Map<String, String> params;

    protected void setUp() throws Exception {
        this.geoServerImpl = new GeoServerImpl();
        this.geoServerImpl.add((ServiceInfo)new WMSInfoImpl());
        this.wms = new WMS((GeoServer)this.geoServerImpl);
        this.request = new MockHttpServletRequest();
        this.params = new HashMap<String, String>();
    }

    protected void tearDown() throws Exception {
        this.wms = null;
        this.request = null;
        this.params = null;
    }

    private DescribeLayerRequest getRequest(Map<String, String> params) throws ServiceException {
        DescribeLayerKvpRequestReader reader = new DescribeLayerKvpRequestReader(params, this.wms);
        return (DescribeLayerRequest)reader.getRequest((HttpServletRequest)this.request);
    }

    public void testGetRequestNullHttpReq() {
        try {
            this.getRequest(null);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected NPE on null request");
        }
        catch (NullPointerException e) {
            DescribeLayerKvpRequestReaderTest.assertTrue((boolean)true);
        }
    }

    public void testGetRequestNoVersion() {
        this.params.put("LAYERS", "topp:states");
        try {
            this.getRequest(this.params);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected ServiceException if version is not provided");
        }
        catch (WmsException e) {
            DescribeLayerKvpRequestReaderTest.assertEquals((String)"NoVersionInfo", (String)e.getCode());
        }
    }

    public void testGetRequestInvalidVersion() {
        this.params.put("LAYERS", "topp:states");
        this.params.put("VERSION", "fakeVersion");
        try {
            this.getRequest(this.params);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected ServiceException if the wrong version is requested");
        }
        catch (WmsException e) {
            DescribeLayerKvpRequestReaderTest.assertEquals((String)"InvalidVersion", (String)e.getCode());
        }
    }

    public void testGetRequestNoLayerRequested() {
        this.params.put("VERSION", "1.1.1");
        try {
            this.getRequest(this.params);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected ServiceException if no layer is requested");
        }
        catch (WmsException e) {
            DescribeLayerKvpRequestReaderTest.assertEquals((String)"NoLayerRequested", (String)e.getCode());
        }
    }

    public void testGetRequestLayerNotDefined() {
        CatalogImpl catalog = new CatalogImpl();
        this.geoServerImpl.setCatalog((Catalog)catalog);
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setPrefix("topp");
        ns.setURI("http//www.geoserver.org");
        catalog.add((NamespaceInfo)ns);
        this.params.put("VERSION", "1.1.1");
        this.params.put("LAYERS", "topp:states");
        try {
            this.getRequest(this.params);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected ServiceException if no layer is requested");
        }
        catch (WmsException e) {
            DescribeLayerKvpRequestReaderTest.assertEquals((String)"LayerNotDefined", (String)e.getCode());
        }
    }

    public void testGetRequest() {
        CatalogImpl catalog = new CatalogImpl();
        this.geoServerImpl.setCatalog((Catalog)catalog);
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setPrefix("topp");
        ns.setURI("http//www.geoserver.org");
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setId("fakeWs");
        workspace.setName("fakeWs");
        DataStoreInfoImpl dataStoreInfo = new DataStoreInfoImpl((Catalog)catalog);
        dataStoreInfo.setName("fakeDs");
        dataStoreInfo.setId("fakeDs");
        dataStoreInfo.setWorkspace((WorkspaceInfo)workspace);
        FeatureTypeInfoImpl featureTypeInfo = new FeatureTypeInfoImpl((Catalog)catalog);
        featureTypeInfo.setNamespace((NamespaceInfo)ns);
        featureTypeInfo.setName("states");
        featureTypeInfo.setStore((StoreInfo)dataStoreInfo);
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setResource((ResourceInfo)featureTypeInfo);
        layerInfo.setId("states");
        layerInfo.setName("states");
        catalog.add((NamespaceInfo)ns);
        catalog.add((WorkspaceInfo)workspace);
        catalog.add((StoreInfo)dataStoreInfo);
        catalog.add((ResourceInfo)featureTypeInfo);
        catalog.add((LayerInfo)layerInfo);
        this.params.put("VERSION", "1.1.1");
        this.params.put("LAYERS", "topp:states");
        DescribeLayerRequest describeRequest = this.getRequest(this.params);
        DescribeLayerKvpRequestReaderTest.assertNotNull((Object)describeRequest);
        DescribeLayerKvpRequestReaderTest.assertNotNull((Object)describeRequest.getLayers());
        DescribeLayerKvpRequestReaderTest.assertEquals((int)1, (int)describeRequest.getLayers().size());
        CoverageStoreInfoImpl coverageStoreInfo = new CoverageStoreInfoImpl((Catalog)catalog);
        coverageStoreInfo.setId("coverageStore");
        coverageStoreInfo.setName("coverageStore");
        coverageStoreInfo.setWorkspace((WorkspaceInfo)workspace);
        CoverageInfoImpl coverageInfo = new CoverageInfoImpl((Catalog)catalog);
        coverageInfo.setNamespace((NamespaceInfo)ns);
        coverageInfo.setName("fakeCoverage");
        coverageInfo.setStore((StoreInfo)coverageStoreInfo);
        layerInfo = new LayerInfoImpl();
        layerInfo.setResource((ResourceInfo)coverageInfo);
        layerInfo.setId("fakeCoverage");
        layerInfo.setName("fakeCoverage");
        catalog.add((StoreInfo)coverageStoreInfo);
        catalog.add((ResourceInfo)coverageInfo);
        catalog.add((LayerInfo)layerInfo);
        this.params.put("LAYERS", "topp:states,topp:fakeCoverage");
        describeRequest = this.getRequest(this.params);
        DescribeLayerKvpRequestReaderTest.assertNotNull((Object)describeRequest);
        DescribeLayerKvpRequestReaderTest.assertNotNull((Object)describeRequest.getLayers());
        DescribeLayerKvpRequestReaderTest.assertEquals((int)2, (int)describeRequest.getLayers().size());
    }
}

