/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureinfo;

import java.util.Iterator;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTemplate;
import org.vfny.geoserver.wms.responses.featureinfo.dummy.Dummy;

public class FeatureTemplateTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new FeatureTemplateTest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithDateAndBoolean() throws Exception {
        FeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        FeatureCollection fc = source.getFeatures();
        Iterator i = fc.iterator();
        try {
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            try {
                template.description(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                FeatureTemplateTest.fail((String)"template threw exception on null value");
            }
        }
        finally {
            fc.close(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRawValue() throws Exception {
        FeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        FeatureCollection fc = source.getFeatures();
        Iterator i = fc.iterator();
        try {
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            try {
                template.template(f, "rawValues.ftl", FeatureTemplateTest.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            fc.close(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithNull() throws Exception {
        FeatureSource source = this.getFeatureSource(MockData.BASIC_POLYGONS);
        FeatureCollection fc = source.getFeatures();
        Iterator i = fc.iterator();
        try {
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            template.description(f);
            f.setAttribute(1, null);
            try {
                template.description(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                FeatureTemplateTest.fail((String)"template threw exception on null value");
            }
        }
        finally {
            fc.close(i);
        }
    }

    public void testAlternateLookup() throws Exception {
        FeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        FeatureCollection fc = source.getFeatures();
        SimpleFeature f = (SimpleFeature)fc.features().next();
        FeatureTemplate template = new FeatureTemplate();
        String result = template.template(f, "dummy.ftl", Dummy.class);
        FeatureTemplateTest.assertEquals((String)"dummy", (String)result);
    }
}

