/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.referencing.CRS;
import org.geotools.xml.transform.TransformerBase;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.responses.helpers.WMSCapsTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMSCapsTransformerTest
extends TestCase {
    private XpathEngine XPATH;
    private static final String baseUrl = "http://localhost/geoserver";
    private static final Set<String> mapFormats = Collections.singleton("image/png");
    private static final Set<String> legendFormats = Collections.singleton("image/png");
    private GeoServerImpl geosConfig;
    private GeoServerInfoImpl geosInfo;
    private WMSInfoImpl wmsInfo;
    private CatalogImpl catalog;
    private WMSCapabilitiesRequest req;

    protected void setUp() throws Exception {
        this.geosConfig = new GeoServerImpl();
        this.geosInfo = new GeoServerInfoImpl((GeoServer)this.geosConfig);
        this.geosInfo.setContact((ContactInfo)new ContactInfoImpl());
        this.geosConfig.setGlobal((GeoServerInfo)this.geosInfo);
        this.wmsInfo = new WMSInfoImpl();
        this.geosConfig.add((ServiceInfo)this.wmsInfo);
        this.catalog = new CatalogImpl();
        this.geosConfig.setCatalog((Catalog)this.catalog);
        this.req = new WMSCapabilitiesRequest(new WMS((GeoServer)this.geosConfig));
        this.req.setBaseUrl(baseUrl);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.XPATH = XMLUnit.newXpathEngine();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHeader() throws Exception {
        WMSCapsTransformer tr = new WMSCapsTransformer(baseUrl, mapFormats, legendFormats);
        StringWriter writer = new StringWriter();
        tr.transform((Object)this.req, (Writer)writer);
        String content = writer.getBuffer().toString();
        WMSCapsTransformerTest.assertTrue((boolean)content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        String dtdDef = "<!DOCTYPE WMT_MS_Capabilities SYSTEM \"http://localhost/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd\">";
        WMSCapsTransformerTest.assertTrue((boolean)content.contains(dtdDef));
    }

    public void testRootElement() throws Exception {
        WMSCapsTransformer tr = new WMSCapsTransformer(baseUrl, mapFormats, legendFormats);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        Element root = dom.getDocumentElement();
        WMSCapsTransformerTest.assertEquals((String)"WMT_MS_Capabilities", (String)root.getNodeName());
        WMSCapsTransformerTest.assertEquals((String)"1.1.1", (String)root.getAttribute("version"));
        WMSCapsTransformerTest.assertEquals((String)"0", (String)root.getAttribute("updateSequence"));
        this.geosInfo.setUpdateSequence(10L);
        tr = new WMSCapsTransformer(baseUrl, mapFormats, legendFormats);
        dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        root = dom.getDocumentElement();
        WMSCapsTransformerTest.assertEquals((String)"10", (String)root.getAttribute("updateSequence"));
    }

    public void testServiceSection() throws Exception {
        this.wmsInfo.setTitle("title");
        this.wmsInfo.setAbstract("abstract");
        this.wmsInfo.getKeywords().add("k1");
        this.wmsInfo.getKeywords().add("k2");
        this.wmsInfo.setOnlineResource("http://onlineresource/fake");
        ContactInfoImpl contactInfo = new ContactInfoImpl();
        this.geosInfo.setContact((ContactInfo)contactInfo);
        contactInfo.setContactPerson("contactPerson");
        contactInfo.setContactOrganization("contactOrganization");
        contactInfo.setContactPosition("contactPosition");
        contactInfo.setAddress("address");
        contactInfo.setAddressType("addressType");
        contactInfo.setAddressCity("city");
        contactInfo.setAddressState("state");
        contactInfo.setAddressPostalCode("postCode");
        contactInfo.setAddressCountry("country");
        contactInfo.setContactVoice("voice");
        contactInfo.setContactEmail("email");
        contactInfo.setContactFacsimile("fax");
        this.wmsInfo.setFees("fees");
        this.wmsInfo.setAccessConstraints("accessConstraints");
        WMSCapsTransformer tr = new WMSCapsTransformer(baseUrl, mapFormats, legendFormats);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        String service = "/WMT_MS_Capabilities/Service";
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WMS", (String)(service + "/Name"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"title", (String)(service + "/Title"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract", (String)(service + "/Abstract"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"k1", (String)(service + "/KeywordList/Keyword[1]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"k2", (String)(service + "/KeywordList/Keyword[2]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/geoserver/wms", (String)(service + "/OnlineResource/@xlink:href"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactPerson", (String)(service + "/ContactInformation/ContactPersonPrimary/ContactPerson"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactOrganization", (String)(service + "/ContactInformation/ContactPersonPrimary/ContactOrganization"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactPosition", (String)(service + "/ContactInformation/ContactPosition"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"address", (String)(service + "/ContactInformation/ContactAddress/Address"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"addressType", (String)(service + "/ContactInformation/ContactAddress/AddressType"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"city", (String)(service + "/ContactInformation/ContactAddress/City"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"state", (String)(service + "/ContactInformation/ContactAddress/StateOrProvince"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"postCode", (String)(service + "/ContactInformation/ContactAddress/PostCode"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"country", (String)(service + "/ContactInformation/ContactAddress/Country"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"voice", (String)(service + "/ContactInformation/ContactVoiceTelephone"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"fax", (String)(service + "/ContactInformation/ContactFacsimileTelephone"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"email", (String)(service + "/ContactInformation/ContactElectronicMailAddress"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"fees", (String)(service + "/Fees"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"accessConstraints", (String)(service + "/AccessConstraints"), (Document)dom);
    }

    public void testCRSList() throws Exception {
        WMSCapsTransformer tr = new WMSCapsTransformer(baseUrl, mapFormats, legendFormats);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        Set supportedCodes = CRS.getSupportedCodes((String)"EPSG");
        supportedCodes.addAll(CRS.getSupportedCodes((String)"AUTO"));
        NodeList allCrsCodes = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/SRS", dom);
        WMSCapsTransformerTest.assertEquals((int)supportedCodes.size(), (int)allCrsCodes.getLength());
    }

    public void testLimitedCRSList() throws Exception {
        this.wmsInfo.getSRS().add("EPSG:3246");
        this.wmsInfo.getSRS().add("EPSG:23030");
        WMSCapsTransformer tr = new WMSCapsTransformer(baseUrl, mapFormats, legendFormats);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        NodeList limitedCrsCodes = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/SRS", dom);
        WMSCapsTransformerTest.assertEquals((int)2, (int)limitedCrsCodes.getLength());
    }
}

