/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.KMLSuperOverlayTransformer;
import org.w3c.dom.Document;

public class KMLSuperOverlayTransformerTest
extends WMSTestSupport {
    public static QName DISPERSED_FEATURES = new QName(MockData.SF_URI, "Dispersed", MockData.SF_PREFIX);
    WMSMapContext mapContext;
    MapLayer mapLayer;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMLSuperOverlayTransformerTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.mapLayer = this.createMapLayer(DISPERSED_FEATURES);
        this.mapContext = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        this.mapContext.addLayer(this.mapLayer);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("allsymbolizers", ((Object)((Object)this)).getClass().getResource("allsymbolizers.sld"));
        dataDirectory.addStyle("SingleFeature", ((Object)((Object)this)).getClass().getResource("singlefeature.sld"));
        dataDirectory.addStyle("Bridge", ((Object)((Object)this)).getClass().getResource("bridge.sld"));
        dataDirectory.addPropertiesType(DISPERSED_FEATURES, ((Object)((Object)this)).getClass().getResource("Dispersed.properties"), Collections.EMPTY_MAP);
        dataDirectory.copyTo(((Object)((Object)this)).getClass().getResourceAsStream("bridge.png"), "styles/bridge.png");
    }

    public void testWorldBoundsSuperOverlay() throws Exception {
        KMLSuperOverlayTransformer transformer = new KMLSuperOverlayTransformer(this.mapContext);
        transformer.setIndentation(2);
        this.mapContext.setAreaOfInterest(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)this.mapLayer, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        KMLSuperOverlayTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        KMLSuperOverlayTransformerTest.assertEquals((int)5, (int)document.getElementsByTagName("Region").getLength());
        KMLSuperOverlayTransformerTest.assertEquals((int)4, (int)document.getElementsByTagName("NetworkLink").getLength());
        KMLSuperOverlayTransformerTest.assertEquals((int)0, (int)document.getElementsByTagName("GroundOverlay").getLength());
    }

    public void testSubtileSuperOverlay() throws Exception {
        KMLSuperOverlayTransformer transformer = new KMLSuperOverlayTransformer(this.mapContext);
        transformer.setIndentation(2);
        this.mapContext.setAreaOfInterest(new ReferencedEnvelope(0.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)this.mapLayer, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        KMLSuperOverlayTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        KMLSuperOverlayTransformerTest.assertEquals((int)6, (int)document.getElementsByTagName("Region").getLength());
        KMLSuperOverlayTransformerTest.assertEquals((int)5, (int)document.getElementsByTagName("NetworkLink").getLength());
        KMLSuperOverlayTransformerTest.assertEquals((int)0, (int)document.getElementsByTagName("GroundOverlay").getLength());
    }
}

