/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import java.net.URL;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class SVGTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new SVGTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("multifts", ((Object)((Object)this)).getClass().getResource("./polyMultiFts.sld"));
    }

    public void testBasicSvgGenerator() throws Exception {
        this.getWMS().setSvgRenderer("Simple");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&featureid=BasicPolygons.1107531493643");
        SVGTest.assertEquals((int)1, (int)doc.getElementsByTagName("svg").getLength());
        SVGTest.assertEquals((int)1, (int)doc.getElementsByTagName("g").getLength());
    }

    public void testBasicSvgGeneratorMultipleFts() throws Exception {
        this.getWMS().setSvgRenderer("Simple");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=multifts" + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&featureid=BasicPolygons.1107531493643");
        SVGTest.assertEquals((int)1, (int)doc.getElementsByTagName("svg").getLength());
        SVGTest.assertEquals((int)1, (int)doc.getElementsByTagName("g").getLength());
    }

    public void testBatikSvgGenerator() throws Exception {
        try {
            new URL("http://www.w3.org").openConnection().connect();
        }
        catch (Exception e) {
            return;
        }
        this.getWMS().setSvgRenderer("Batik");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&featureid=BasicPolygons.1107531493643");
        SVGTest.assertEquals((int)1, (int)doc.getElementsByTagName("svg").getLength());
        SVGTest.assertTrue((doc.getElementsByTagName("g").getLength() > 1 ? 1 : 0) != 0);
    }

    public void testBatikMultipleFts() throws Exception {
        try {
            new URL("http://www.w3.org").openConnection().connect();
        }
        catch (Exception e) {
            return;
        }
        this.getWMS().setSvgRenderer("Batik");
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=image/svg+xml&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=multifts" + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&featureid=BasicPolygons.1107531493643");
        SVGTest.assertEquals((int)1, (int)doc.getElementsByTagName("svg").getLength());
        SVGTest.assertTrue((doc.getElementsByTagName("g").getLength() > 1 ? 1 : 0) != 0);
    }
}

