/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.platform.ServiceException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;

public class TextFeatureInfoResponse
extends AbstractFeatureInfoResponse {
    public TextFeatureInfoResponse() {
        this.format = "text/plain";
        this.supportedFormats = Collections.singletonList("text/plain");
    }

    public HashMap getResponseHeaders() {
        return new HashMap();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        int featuresPrinted;
        PrintWriter writer;
        block14: {
            Charset charSet = this.getRequest().getWMS().getCharSet();
            OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
            writer = new PrintWriter(osw);
            featuresPrinted = 0;
            int maxfeatures = this.getRequest().getFeatureCount();
            FeatureIterator reader = null;
            try {
                try {
                    int size = this.results.size();
                    int i = 0;
                    while (i < size) {
                        FeatureCollection fr = (FeatureCollection)this.results.get(i);
                        reader = fr.features();
                        if (reader.hasNext() && featuresPrinted < maxfeatures) {
                            writer.println("Results for FeatureType '" + ((SimpleFeatureType)fr.getSchema()).getTypeName() + "':");
                        }
                        while (reader.hasNext()) {
                            SimpleFeature f = (SimpleFeature)reader.next();
                            SimpleFeatureType schema = f.getFeatureType();
                            List types = schema.getAttributeDescriptors();
                            if (featuresPrinted >= maxfeatures) continue;
                            writer.println("--------------------------------------------");
                            for (AttributeDescriptor descriptor : types) {
                                Name name = descriptor.getName();
                                if (Geometry.class.isAssignableFrom(descriptor.getType().getBinding())) {
                                    Geometry g = (Geometry)f.getAttribute(name);
                                    writer.println(name + " = [GEOMETRY (" + g.getGeometryType() + ") with " + g.getNumPoints() + " points]");
                                    continue;
                                }
                                writer.println(name + " = " + f.getAttribute(name));
                            }
                            writer.println("--------------------------------------------");
                            ++featuresPrinted;
                        }
                        ++i;
                    }
                }
                catch (Exception ife) {
                    LOGGER.log(Level.WARNING, "Error generating getFeaturInfo, HTML format", ife);
                    writer.println("Unable to generate information " + ife);
                    if (reader != null) {
                        reader.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            if (reader != null) {
                reader.close();
            }
        }
        if (featuresPrinted == 0) {
            writer.println("no features were found");
        }
        writer.flush();
    }

    public String getContentDisposition() {
        return null;
    }
}

