/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMLLegendTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLRasterTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLSuperOverlayTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.vfny.geoserver.wms.responses.map.kml.KMLVectorTransformer;
import org.xml.sax.ContentHandler;

public class KMLTransformer
extends TransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    boolean kmz = false;

    public KMLTransformer() {
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLTranslator(handler);
    }

    public void setKmz(boolean kmz) {
        this.kmz = kmz;
    }

    protected class KMLTranslator
    extends TransformerBase.TranslatorSupport {
        static final double TOLERANCE = 1.0E-6;
        static final int RULES = 0;
        static final int ELSE_RULES = 1;
        private double scaleDenominator;

        public KMLTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            boolean group;
            this.start("kml", KMLUtils.attributes(new String[]{"xmlns", "http://www.opengis.net/kml/2.2", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd"}));
            WMSMapContext mapContext = (WMSMapContext)((Object)o);
            GetMapRequest request = mapContext.getRequest();
            MapLayer[] layers = mapContext.getLayers();
            this.scaleDenominator = 1.0;
            try {
                this.scaleDenominator = RendererUtilities.calculateScale((ReferencedEnvelope)mapContext.getAreaOfInterest(), (int)mapContext.getMapWidth(), (int)mapContext.getMapHeight(), null);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error calculating scale denominator", e);
            }
            LOGGER.log(Level.FINE, "scale denominator = " + this.scaleDenominator);
            boolean bl = group = layers.length > 1 || request.getLegend();
            if (group) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < layers.length) {
                    sb.append(String.valueOf(layers[i].getTitle()) + ",");
                    ++i;
                }
                sb.setLength(sb.length() - 1);
                this.start("Document");
                this.element("name", sb.toString());
            }
            int i = 0;
            while (i < layers.length) {
                MapLayer layer = layers[i];
                MapLayerInfo layerInfo = mapContext.getRequest().getLayers()[i];
                Boolean superoverlay = (Boolean)mapContext.getRequest().getFormatOptions().get("superoverlay");
                Boolean bl2 = superoverlay = superoverlay == null ? Boolean.FALSE : superoverlay;
                if (superoverlay.booleanValue()) {
                    this.encodeSuperOverlayLayer(mapContext, layer);
                } else if (layerInfo.getType() != MapLayerInfo.TYPE_RASTER) {
                    this.encodeVectorLayer(mapContext, layer);
                } else {
                    this.encodeRasterLayer(mapContext, layer);
                }
                ++i;
            }
            if (request.getLegend()) {
                i = 0;
                while (i < layers.length) {
                    MapLayer layer = layers[i];
                    this.encodeLegend(mapContext, layer);
                    ++i;
                }
            }
            if (group) {
                this.end("Document");
            }
            this.end("kml");
        }

        protected void encodeVectorLayer(WMSMapContext mapContext, MapLayer layer) {
            FeatureSource featureSource = layer.getFeatureSource();
            FeatureCollection<SimpleFeatureType, SimpleFeature> features = null;
            try {
                features = KMLUtils.loadFeatureCollection((FeatureSource<SimpleFeatureType, SimpleFeature>)featureSource, layer, mapContext);
                if (features == null) {
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (KMLTransformer.this.kmz) {
                boolean useVector;
                int kmscore = mapContext.getRequest().getWMS().getKmScore();
                Object kmScoreObj = mapContext.getRequest().getFormatOptions().get("kmscore");
                if (kmScoreObj != null) {
                    kmscore = (Integer)kmScoreObj;
                }
                if (useVector = this.useVectorOutput(kmscore, features.size())) {
                    KMLVectorTransformer tx = this.createVectorTransformer(mapContext, layer);
                    this.initTransformer(tx);
                    tx.setScaleDenominator(this.scaleDenominator);
                    tx.createTranslator(this.contentHandler).encode(features);
                } else {
                    KMLRasterTransformer tx = this.createRasterTransfomer(mapContext);
                    this.initTransformer(tx);
                    tx.setInline(true);
                    tx.createTranslator(this.contentHandler).encode((Object)layer);
                }
            } else {
                KMLVectorTransformer tx = this.createVectorTransformer(mapContext, layer);
                this.initTransformer(tx);
                tx.setScaleDenominator(this.scaleDenominator);
                tx.createTranslator(this.contentHandler).encode(features);
            }
        }

        protected KMLRasterTransformer createRasterTransfomer(WMSMapContext mapContext) {
            return new KMLRasterTransformer(mapContext);
        }

        protected KMLVectorTransformer createVectorTransformer(WMSMapContext mapContext, MapLayer layer) {
            return new KMLVectorTransformer(mapContext, layer);
        }

        protected void encodeRasterLayer(WMSMapContext mapContext, MapLayer layer) {
            KMLRasterTransformer tx = this.createRasterTransfomer(mapContext);
            this.initTransformer(tx);
            tx.setInline(KMLTransformer.this.kmz);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeSuperOverlayLayer(WMSMapContext mapContext, MapLayer layer) {
            KMLSuperOverlayTransformer tx = new KMLSuperOverlayTransformer(mapContext);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeLegend(WMSMapContext mapContext, MapLayer layer) {
            KMLLegendTransformer tx = new KMLLegendTransformer(mapContext);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void initTransformer(KMLTransformerBase delegate) {
            delegate.setIndentation(KMLTransformer.this.getIndentation());
            delegate.setEncoding(KMLTransformer.this.getEncoding());
            delegate.setStandAlone(false);
        }

        double computeScaleDenominator(MapLayer layer, WMSMapContext mapContext) {
            Rectangle paintArea = new Rectangle(mapContext.getMapWidth(), mapContext.getMapHeight());
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapContext.getAreaOfInterest(), (Rectangle)paintArea);
            try {
                return RendererUtilities.calculateScale((Envelope)mapContext.getAreaOfInterest(), (CoordinateReferenceSystem)mapContext.getCoordinateReferenceSystem(), (int)paintArea.width, (int)paintArea.height, (double)90.0);
            }
            catch (Exception e) {
                return 1.0 / worldToScreen.getScaleX();
            }
        }

        boolean useVectorOutput(int kmscore, int numFeatures) {
            if (kmscore == 100) {
                return true;
            }
            if (kmscore == 0) {
                return false;
            }
            double magic = Math.pow(10.0, kmscore / 15);
            return !((double)numFeatures > magic);
        }
    }
}

