/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.responses.decoration;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geoserver.wms.responses.MapDecoration;
import org.geotools.util.SoftValueHashMap;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.wms.WMSMapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatermarkDecoration
implements MapDecoration {
    private static final Logger LOGGER = Logger.getLogger("org.geoserver.wms.responses");
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final int TRANSPARENT_CODE = 0xFFFFFF;
    private String imageURL;
    private float opacity = 1.0f;
    private static final Map<URL, LogoCacheEntry> logoCache = new SoftValueHashMap();

    @Override
    public void loadOptions(Map<String, String> options) {
        this.imageURL = options.get("url");
        if (options.containsKey("opacity")) {
            try {
                this.opacity = Float.valueOf(options.get("opacity")).floatValue() / 100.0f;
                this.opacity = Math.max(Math.min(this.opacity, 1.0f), 0.0f);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Invalid opacity value: " + options.get("opacity"), e);
            }
        }
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContext mapContext) {
        try {
            BufferedImage logo = this.getLogo(mapContext);
            return new Dimension(logo.getWidth(), logo.getHeight());
        }
        catch (Exception e) {
            return new Dimension(20, 20);
        }
    }

    @Override
    public void paint(Graphics2D g2D, Rectangle paintArea, WMSMapContext mapContext) throws MalformedURLException, ClassCastException, IOException {
        BufferedImage logo = this.getLogo(mapContext);
        if (logo != null) {
            Composite oldComposite = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
            AffineTransform tx = AffineTransform.getTranslateInstance(paintArea.getX(), paintArea.getY());
            tx.scale(paintArea.getWidth() / (double)logo.getWidth(), paintArea.getHeight() / (double)logo.getHeight());
            g2D.drawImage(logo, tx, null);
            g2D.setComposite(oldComposite);
        }
    }

    protected BufferedImage getLogo(WMSMapContext mapContext) throws IOException {
        BufferedImage logo = null;
        URL url = null;
        try {
            File file;
            url = new URL(GeoserverDataDirectory.getGeoserverDataDirectory().toURL(), this.imageURL);
            if ((url.getProtocol() == null || url.getProtocol().equals("file")) && (file = GeoserverDataDirectory.findDataFile((String)this.imageURL)).exists()) {
                url = file.toURL();
            }
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url == null) {
            return null;
        }
        LogoCacheEntry entry = logoCache.get(url);
        if (entry == null || entry.isExpired()) {
            logo = ImageIO.read(url);
            if (url.getProtocol().equals("file")) {
                entry = new LogoCacheEntry(logo, new File(url.getFile()));
                logoCache.put(url, entry);
            }
        } else {
            logo = entry.getLogo();
        }
        return logo;
    }

    private static class LogoCacheEntry {
        private BufferedImage logo;
        private long lastModified;
        private File file;

        public LogoCacheEntry(BufferedImage logo, File file) {
            this.logo = logo;
            this.file = file;
            this.lastModified = file.lastModified();
        }

        public boolean isExpired() {
            return this.file.lastModified() > this.lastModified;
        }

        public BufferedImage getLogo() {
            return this.logo;
        }
    }
}

