/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ServiceException;
import org.geotools.filter.function.EnvFunction;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.featureInfo.GetFeatureInfoDelegate;
import org.vfny.geoserver.wms.responses.featureInfo.GmlFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.featureInfo.HTMLTableFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.featureInfo.TextFeatureInfoResponse;

public class GetFeatureInfoResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)GetMapResponse.class.getPackage().getName());
    private static final List delegates = new LinkedList();
    private static final List supportedMimeTypes = new LinkedList();
    private GetFeatureInfoDelegate delegate;

    static {
        AbstractFeatureInfoResponse producer = new TextFeatureInfoResponse();
        supportedMimeTypes.addAll(((GetFeatureInfoDelegate)producer).getSupportedFormats());
        delegates.add(producer);
        producer = new HTMLTableFeatureInfoResponse();
        supportedMimeTypes.addAll(((GetFeatureInfoDelegate)producer).getSupportedFormats());
        delegates.add(producer);
        producer = new GmlFeatureInfoResponse();
        supportedMimeTypes.addAll(((GetFeatureInfoDelegate)producer).getSupportedFormats());
        delegates.add(producer);
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request request) throws ServiceException {
        LOGGER.entering(this.getClass().getName(), "execute", new Object[]{request});
        GetFeatureInfoRequest getFeatureInfoReq = (GetFeatureInfoRequest)request;
        EnvFunction.setLocalValues((Map)getFeatureInfoReq.getGetMapRequest().getEnv());
        try {
            this.delegate = GetFeatureInfoResponse.getDelegate(getFeatureInfoReq);
            this.delegate.execute(request);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been proceced");
        }
        return this.delegate.getContentType(gs);
    }

    public String getContentEncoding() {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been proceced");
        }
        return this.delegate.getContentEncoding();
    }

    public void abort(ServiceInfo gs) {
        if (this.delegate != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("asking delegate for aborting the process");
            }
            this.delegate.abort(gs);
        }
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.delegate == null) {
            throw new IllegalStateException("No GetMapDelegate is setted, make sure you have called execute and it has succeed");
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("asking delegate for write to ").append(out).toString());
        }
        this.delegate.writeTo(out);
    }

    private static GetFeatureInfoDelegate getDelegate(GetFeatureInfoRequest request) throws WmsException {
        String requestFormat = request.getInfoFormat();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("request format is ").append(requestFormat).toString());
        }
        GetFeatureInfoDelegate curDelegate2 = null;
        Class<?> delegateClass = null;
        for (GetFeatureInfoDelegate curDelegate2 : delegates) {
            if (!curDelegate2.canProduce(requestFormat)) continue;
            delegateClass = curDelegate2.getClass();
            if (!LOGGER.isLoggable(Level.FINER)) break;
            LOGGER.finer(new StringBuffer("found GetFeatureInfoDelegate ").append(delegateClass).toString());
            break;
        }
        if (delegateClass == null) {
            delegateClass = new TextFeatureInfoResponse().getClass();
        }
        try {
            curDelegate2 = (GetFeatureInfoDelegate)delegateClass.newInstance();
        }
        catch (Exception ex) {
            throw new WmsException(ex, "Cannot obtain the map generator for the requested format", "GetMapResponse::getDelegate()");
        }
        return curDelegate2;
    }

    public static List getFormats() {
        return supportedMimeTypes;
    }

    public String getContentDisposition() {
        return null;
    }
}

