/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMapService;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.map.kml.KMLNetworkLinkTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.vfny.geoserver.wms.responses.map.kml.KMZMapProducer;

public class KMLReflector {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.responses.map.kml");
    public static final String FORMAT = "application/vnd.google-earth.kml+xml";
    private static Map<String, Map<String, String>> MODES;
    WebMapService wms;
    WMS wmsConfiguration;

    static {
        HashMap<String, Map<String, String>> temp = new HashMap<String, Map<String, String>>();
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("superoverlay", true);
        temp.put("superoverlay", options);
        options = new HashMap();
        options.put("superoverlay", false);
        options.put("regionatemode", null);
        options.put("kmscore", null);
        temp.put("download", options);
        options = new HashMap();
        options.put("superoverlay", false);
        temp.put("refresh", options);
        MODES = temp;
    }

    public KMLReflector(WebMapService wms, WMS wmsConfiguration) {
        this.wms = wms;
        this.wmsConfiguration = wmsConfiguration;
    }

    public void wms(GetMapRequest request, HttpServletResponse response) throws Exception {
        KMLReflector.doWms(request, response, this.wms, this.wmsConfiguration);
    }

    public static void doWms(GetMapRequest request, HttpServletResponse response, WebMapService wms, WMS wmsConfiguration) throws Exception {
        Boolean superoverlay;
        StringBuffer filename = new StringBuffer();
        boolean containsRasterData = false;
        boolean isRegionatingFriendly = true;
        int i = 0;
        while (i < request.getLayers().length) {
            MapLayerInfo layer = request.getLayers()[i];
            String name = layer.getName();
            boolean bl = containsRasterData = containsRasterData || layer.getType() == MapLayerInfo.TYPE_RASTER;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                isRegionatingFriendly = isRegionatingFriendly && layer.getFeature().getFeatureSource(null, null).getQueryCapabilities().isReliableFIDSupported();
            } else if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                isRegionatingFriendly = isRegionatingFriendly && layer.getRemoteFeatureSource().getQueryCapabilities().isReliableFIDSupported();
            }
            int j = name.indexOf(58);
            if (j > -1) {
                name = name.substring(j + 1);
            }
            filename.append(String.valueOf(name) + "_");
            ++i;
        }
        String mode = KMLReflector.caseInsensitiveParam(request.getHttpServletRequest().getParameterMap(), "mode", wmsConfiguration.getKmlReflectorMode());
        if (!MODES.containsKey(mode)) {
            throw new WmsException("Unknown KML mode: " + mode);
        }
        HashMap<String, String> modeOptions = new HashMap<String, String>(MODES.get(mode));
        if ("superoverlay".equals(mode)) {
            String submode = KMLReflector.caseInsensitiveParam(request.getHttpServletRequest().getParameterMap(), "superoverlay_mode", wmsConfiguration.getKmlSuperoverlayMode());
            if ("raster".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "raster");
            } else if ("overview".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "overview");
            } else if ("hybrid".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "hybrid");
            } else if ("auto".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "auto");
            } else {
                throw new WmsException("Unknown overlay mode: " + submode);
            }
        }
        if (request.getWidth() < 1) {
            request.setWidth(mode.equals("refresh") || containsRasterData ? 1024 : 256);
        }
        if (request.getHeight() < 1) {
            request.setHeight(mode.equals("refresh") || containsRasterData ? 1024 : 256);
        }
        request.setSRS("EPSG:4326");
        wms.reflect(request);
        Map fo = request.getFormatOptions();
        KMLReflector.merge(fo, modeOptions);
        if (fo.get("kmattr") == null) {
            fo.put("kmattr", wmsConfiguration.getKmlKmAttr());
        }
        if (fo.get("kmscore") == null) {
            fo.put("kmscore", wmsConfiguration.getKmScore());
        }
        if (fo.get("kmplacemark") == null) {
            fo.put("kmplacemark", wmsConfiguration.getKmlPlacemark());
        }
        if ((superoverlay = (Boolean)fo.get("superoverlay")) == null) {
            superoverlay = Boolean.FALSE;
        }
        String formatExtension = ".kmz";
        if (superoverlay.booleanValue()) {
            request.setFormat("application/vnd.google-earth.kmz+xml");
            request.setBbox(KMLUtils.expandToTile(request.getBbox()));
        } else if (mode.equals("refresh") || containsRasterData) {
            request.setFormat("application/vnd.google-earth.kmz+xml");
        } else if (!Arrays.asList(KMZMapProducer.OUTPUT_FORMATS).contains(request.getFormat())) {
            request.setFormat(FORMAT);
            formatExtension = ".kml";
        }
        response.setContentType(request.getFormat());
        filename.setLength(filename.length() - 1);
        response.setHeader("Content-Disposition", "attachment; filename=" + filename.toString() + formatExtension);
        if ("download".equals(mode)) {
            GetMapResponse wmsResponse = wms.getMap(request);
            wmsResponse.execute(request);
            wmsResponse.writeTo((OutputStream)response.getOutputStream());
        } else {
            KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer();
            transformer.setIndentation(3);
            Charset encoding = request.getWMS().getCharSet();
            transformer.setEncoding(encoding);
            transformer.setEncodeAsRegion(superoverlay);
            transformer.transform((Object)request, (OutputStream)response.getOutputStream());
        }
    }

    private static String caseInsensitiveParam(Map params, String paramname, String defaultValue) {
        String value = defaultValue;
        for (Map.Entry o : params.entrySet()) {
            Map.Entry entry = o;
            if (!(entry.getKey() instanceof String) || !paramname.equalsIgnoreCase((String)entry.getKey())) continue;
            Object obj = entry.getValue();
            String string = value = obj instanceof String[] ? ((String[])obj)[0].toLowerCase() : value;
        }
        return value;
    }

    private static void merge(Map options, Map addition) {
        for (Map.Entry o : addition.entrySet()) {
            Map.Entry entry = o;
            if (entry.getValue() == null) {
                options.remove(entry.getKey());
                continue;
            }
            options.put(entry.getKey(), entry.getValue());
        }
    }
}

