/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Point;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.kml.KMLVectorTransformer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.styling.Style;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.feature.simple.SimpleFeatureType;
import org.w3c.dom.Document;

public class KMLVectorTransformerTest
extends TestCase {
    private WMSMockData mockData;

    protected void setUp() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("atom", "http://purl.org/atom/ns#");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    protected void tearDown() throws Exception {
        new GeoServerExtensions().setApplicationContext(null);
    }

    public void testSetStandAlone() throws Exception {
        SimpleFeatureCollection features = FeatureCollections.newCollection();
        Style style = this.mockData.getDefaultStyle().getStyle();
        DefaultMapLayer mapLayer = new DefaultMapLayer((FeatureCollection)features, style);
        WMSMapContext mapContext = new WMSMapContext();
        GetMapRequest request = this.mockData.createRequest();
        mapContext.setRequest(request);
        KMLVectorTransformer transformer = new KMLVectorTransformer(this.mockData.getWMS(), mapContext, (MapLayer)mapLayer);
        transformer.setStandAlone(true);
        Document document = WMSTestSupport.transform(features, (TransformerBase)transformer);
        KMLVectorTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        transformer.setStandAlone(false);
        document = WMSTestSupport.transform(features, (TransformerBase)transformer);
        KMLVectorTransformerTest.assertEquals((String)"Document", (String)document.getDocumentElement().getNodeName());
    }

    public void testEncodeWithPaging() throws Exception {
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("TestPoints", Point.class);
        FeatureTypeInfo typeInfo = layer.getFeature();
        SimpleFeatureType featureType = (SimpleFeatureType)typeInfo.getFeatureType();
        this.mockData.addFeature(featureType, new Object[]{"name1", "POINT(1 1)"});
        this.mockData.addFeature(featureType, new Object[]{"name2", "POINT(2 2)"});
        this.mockData.addFeature(featureType, new Object[]{"name3", "POINT(3 3)"});
        this.mockData.addFeature(featureType, new Object[]{"name4", "POINT(4 4)"});
        SimpleFeatureSource fs = (SimpleFeatureSource)typeInfo.getFeatureSource(null, null);
        SimpleFeatureCollection features = fs.getFeatures();
        Style style = this.mockData.getDefaultStyle().getStyle();
        DefaultMapLayer mapLayer = new DefaultMapLayer((FeatureCollection)features, style);
        mapLayer.setTitle("TestPointsTitle");
        GetMapRequest request = this.mockData.createRequest();
        request.setLayers(Collections.singletonList(layer));
        request.setMaxFeatures(Integer.valueOf(2));
        request.setStartIndex(Integer.valueOf(2));
        request.setFormatOptions(Collections.singletonMap("relLinks", "true"));
        request.setBaseUrl("baseurl");
        WMSMapContext mapContext = new WMSMapContext();
        mapContext.setRequest(request);
        KMLVectorTransformer transformer = new KMLVectorTransformer(this.mockData.getWMS(), mapContext, (MapLayer)mapLayer);
        transformer.setStandAlone(false);
        transformer.setIndentation(2);
        Document dom = WMSTestSupport.transform(features, (TransformerBase)transformer);
        XMLAssert.assertXpathExists((String)"//Document/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"TestPointsTitle", (String)"//Document/name", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Document/atom:link", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"prev", (String)"//Document/atom:link[1]/@rel", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"next", (String)"//Document/atom:link[2]/@rel", (Document)dom);
        String expectedLink = "baseurl/rest/geos/TestPoints.kml?startindex=0&maxfeatures=2";
        XMLAssert.assertXpathEvaluatesTo((String)expectedLink, (String)"//Document/atom:link[1]/@href", (Document)dom);
        expectedLink = "baseurl/rest/geos/TestPoints.kml?startindex=4&maxfeatures=2";
        XMLAssert.assertXpathEvaluatesTo((String)expectedLink, (String)"//Document/atom:link[2]/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"prev", (String)"//Document/NetworkLink[1]/@id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"next", (String)"//Document/NetworkLink[2]/@id", (Document)dom);
        expectedLink = "baseurl/rest/geos/TestPoints.kml?startindex=0&maxfeatures=2";
        XMLAssert.assertXpathEvaluatesTo((String)expectedLink, (String)"//Document/NetworkLink[1]/Link/href", (Document)dom);
        expectedLink = "baseurl/rest/geos/TestPoints.kml?startindex=4&maxfeatures=2";
        XMLAssert.assertXpathEvaluatesTo((String)"next", (String)"//Document/NetworkLink[2]/@id", (Document)dom);
    }
}

