/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureSourceMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class RenderedImageMapOutputFormatTest
extends WMSTestSupport {
    private static final Logger LOGGER = Logging.getLogger((String)RenderedImageMapOutputFormatTest.class.getPackage().getName());
    private RenderedImageMapOutputFormat rasterMapProducer;
    private String mapFormat = "image/gif";

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new RenderedImageMapOutputFormatTest());
    }

    public void setUpInternal() throws Exception {
        Logging.getLogger((String)"org.geotools.rendering").setLevel(Level.OFF);
        super.setUpInternal();
        this.rasterMapProducer = this.getProducerInstance();
    }

    protected RenderedImageMapOutputFormat getProducerInstance() {
        return new DummyRasterMapProducer(this.getWMS());
    }

    public void tearDownInternal() throws Exception {
        this.rasterMapProducer = null;
        super.tearDownInternal();
    }

    public String getMapFormat() {
        return this.mapFormat;
    }

    public void testSimpleGetMapQuery() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = new GetMapRequest();
        WMSMapContext map = new WMSMapContext();
        map.setAreaOfInterest(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        map.addLayer(fs, basicStyle);
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("testSimpleGetMapQuery", image);
    }

    public void testDefaultStyle() throws Exception {
        List typeInfos = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo info : typeInfos) {
            if (!info.getQualifiedName().getNamespaceURI().equals(MockData.CITE_URI) || info.getFeatureType().getGeometryDescriptor() == null) continue;
            this.testDefaultStyle(info.getFeatureSource(null, null));
        }
    }

    public void testBlueLake() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        WMSMapContext map = new WMSMapContext();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addToMap(map, MockData.FORESTS);
        this.addToMap(map, MockData.LAKES);
        this.addToMap(map, MockData.STREAMS);
        this.addToMap(map, MockData.NAMED_PLACES);
        this.addToMap(map, MockData.ROAD_SEGMENTS);
        this.addToMap(map, MockData.PONDS);
        this.addToMap(map, MockData.BUILDINGS);
        this.addToMap(map, MockData.DIVIDED_ROUTES);
        this.addToMap(map, MockData.BRIDGES);
        this.addToMap(map, MockData.MAP_NEATLINE);
        map.setAreaOfInterest(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("testBlueLake", image);
    }

    private void addToMap(WMSMapContext map, QName typeName) throws IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        List layers = this.getCatalog().getLayers((ResourceInfo)ftInfo);
        StyleInfo defaultStyle = ((LayerInfo)layers.get(0)).getDefaultStyle();
        Style style = defaultStyle.getStyle();
        map.addLayer((MapLayer)new FeatureSourceMapLayer(ftInfo.getFeatureSource(null, null), style));
    }

    private void testDefaultStyle(FeatureSource fSource) throws Exception {
        Catalog catalog = this.getCatalog();
        Style style = catalog.getStyleByName("Default").getStyle();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        env.expandToInclude((Envelope)fSource.getBounds());
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        WMSMapContext map = new WMSMapContext();
        GetMapRequest request = new GetMapRequest();
        map.setRequest(request);
        map.addLayer(fSource, style);
        map.setAreaOfInterest(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(false);
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage image = imageMap.getImage();
        imageMap.dispose();
        RenderedImageMapOutputFormatTest.assertNotNull((Object)image);
        String typeName = fSource.getSchema().getName().getLocalPart();
        this.assertNotBlank("testDefaultStyle " + typeName, (BufferedImage)image);
    }

    public void testRenderingErrorsHandling() throws Exception {
        RenderedImageMapOutputFormatTest.assertNotNull((Object)this.forceRenderingError((Exception)new TransformException("fake transform exception")));
        RenderedImageMapOutputFormatTest.assertNotNull((Object)this.forceRenderingError(new NoninvertibleTransformException("fake non invertible exception")));
        RenderedImageMapOutputFormatTest.assertNotNull((Object)this.forceRenderingError((Exception)new IllegalAttributeException("non illegal attribute exception")));
        RenderedImageMapOutputFormatTest.assertNotNull((Object)this.forceRenderingError((Exception)new FactoryException("fake factory exception")));
        try {
            this.forceRenderingError(new RuntimeException("fake runtime exception"));
            RenderedImageMapOutputFormatTest.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            RenderedImageMapOutputFormatTest.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IOException("fake IO exception"));
            RenderedImageMapOutputFormatTest.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            RenderedImageMapOutputFormatTest.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IllegalArgumentException("fake IAE exception"));
            RenderedImageMapOutputFormatTest.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            RenderedImageMapOutputFormatTest.assertTrue((boolean)true);
        }
    }

    private RenderedImage forceRenderingError(final Exception renderExceptionToThrow) throws Exception {
        GetMapRequest request = new GetMapRequest();
        WMSMapContext map = new WMSMapContext();
        map.setMapWidth(100);
        map.setMapHeight(100);
        map.setRequest(request);
        ReferencedEnvelope bounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.setAreaOfInterest(bounds);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.STREAMS.getNamespaceURI(), MockData.STREAMS.getLocalPart());
        SimpleFeatureSource featureSource = (SimpleFeatureSource)ftInfo.getFeatureSource(null, null);
        DecoratingFeatureSource source = new DecoratingFeatureSource((FeatureSource)featureSource){

            public SimpleFeatureCollection getFeatures(Query query) throws IOException {
                throw new RuntimeException(renderExceptionToThrow);
            }
        };
        StyleInfo someStyle = (StyleInfo)this.getCatalog().getStyles().get(0);
        map.addLayer((FeatureSource)source, someStyle.getStyle());
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        return image;
    }

    private static class DummyRasterMapProducer
    extends RenderedImageMapOutputFormat {
        public DummyRasterMapProducer(WMS wms) {
            super("image/gif", new String[]{"image/gif"}, wms);
        }
    }
}

