/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CapabilitiesIntegrationTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new CapabilitiesIntegrationTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        this.getTestData().registerNamespaces(namespaces);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWcs11Coverages();
        dataDirectory.disableDataStore(MockData.SF_PREFIX);
    }

    public void testCapabilities() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        Element e = dom.getDocumentElement();
        CapabilitiesIntegrationTest.assertEquals((String)"WMS_Capabilities", (String)e.getLocalName());
    }

    public void testGetCapsContainsNoDisabledTypes() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        CapabilitiesIntegrationTest.assertEquals((String)"WMS_Capabilities", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Name[text()='sf:PrimitiveGeoFeature'])", (Document)doc);
    }

    public void testFilteredCapabilitiesCite() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0&namespace=cite"), true);
        Element e = dom.getDocumentElement();
        CapabilitiesIntegrationTest.assertEquals((String)"WMS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        CapabilitiesIntegrationTest.assertTrue((xpath.getMatchingNodes("//wms:Layer/wms:Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        CapabilitiesIntegrationTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//wms:Layer/wms:Name[not(starts-with(., cite))]", dom).getLength());
    }

    public void testLayerCount() throws Exception {
        ArrayList layers = new ArrayList(this.getCatalog().getLayers());
        ListIterator it = layers.listIterator();
        while (it.hasNext()) {
            LayerInfo next = (LayerInfo)it.next();
            if (next.enabled() && !next.getName().equals(MockData.GEOMETRYLESS.getLocalPart())) continue;
            it.remove();
        }
        Document dom = this.dom(this.get("wms?request=GetCapabilities&version=1.3.0"), true);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        NodeList nodeLayers = xpath.getMatchingNodes("/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:Layer", dom);
        CapabilitiesIntegrationTest.assertEquals((int)layers.size(), (int)nodeLayers.getLength());
    }

    public void testWorkspaceQualified() throws Exception {
        Document dom = this.dom(this.get("cite/wms?request=getCapabilities&version=1.3.0"), true);
        Element e = dom.getDocumentElement();
        CapabilitiesIntegrationTest.assertEquals((String)"WMS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        CapabilitiesIntegrationTest.assertTrue((xpath.getMatchingNodes("//wms:Layer/wms:Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        CapabilitiesIntegrationTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//wms:Layer/wms:Name[not(starts-with(., cite))]", dom).getLength());
        NodeList nodes = xpath.getMatchingNodes("//wms:Layer//wms:OnlineResource", dom);
        CapabilitiesIntegrationTest.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < nodes.getLength()) {
            e = (Element)nodes.item(i);
            String attribute = e.getAttribute("xlink:href");
            CapabilitiesIntegrationTest.assertTrue((boolean)attribute.contains("geoserver/cite/ows"));
            ++i;
        }
    }

    public void testLayerQualified() throws Exception {
        Document dom = this.dom(this.get("cite/Forests/wms?request=getCapabilities&version=1.3.0"), true);
        Element e = dom.getDocumentElement();
        CapabilitiesIntegrationTest.assertEquals((String)"WMS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        CapabilitiesIntegrationTest.assertTrue((xpath.getMatchingNodes("//wms:Layer/wms:Name[starts-with(., cite:Forests)]", dom).getLength() == 1 ? 1 : 0) != 0);
        CapabilitiesIntegrationTest.assertEquals((int)1, (int)xpath.getMatchingNodes("//wms:Layer/wms:Layer", dom).getLength());
        NodeList nodes = xpath.getMatchingNodes("//wms:Layer//wms:OnlineResource", dom);
        CapabilitiesIntegrationTest.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < nodes.getLength()) {
            e = (Element)nodes.item(i);
            String attribute = e.getAttribute("xlink:href");
            CapabilitiesIntegrationTest.assertTrue((boolean)attribute.contains("geoserver/cite/Forests/ows"));
            ++i;
        }
    }

    public void testAttribution() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Attribution)", (Document)doc);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        AttributionInfo attr = points.getAttribution();
        attr.setTitle("Point Provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:Title)", (Document)doc);
        attr = points.getAttribution();
        attr.setHref("http://example.com/points/provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:OnlineResource)", (Document)doc);
        attr = points.getAttribution();
        attr.setLogoURL("http://example.com/points/logo");
        attr.setLogoType("image/logo");
        attr.setLogoHeight(50);
        attr.setLogoWidth(50);
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:LogoURL)", (Document)doc);
    }

    public void testAlternateStyles() throws Exception {
        StyleInfo pointStyle = this.getCatalog().getStyleByName("point");
        LayerInfo layer = this.getCatalog().getLayerByName("Fifteen");
        layer.getStyles().add(pointStyle);
        this.getCatalog().save(layer);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='cdf:Fifteen'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wms:Layer[wms:Name='cdf:Fifteen']/wms:Style)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String href = xpath.evaluate("//wms:Layer[wms:Name='cdf:Fifteen']/wms:Style[wms:Name='Default']/wms:LegendURL/wms:OnlineResource/@xlink:href", doc);
        CapabilitiesIntegrationTest.assertTrue((boolean)href.contains("GetLegendGraphic"));
        CapabilitiesIntegrationTest.assertTrue((boolean)href.contains("layer=Fifteen"));
        CapabilitiesIntegrationTest.assertFalse((boolean)href.contains("style"));
        href = xpath.evaluate("//wms:Layer[wms:Name='cdf:Fifteen']/wms:Style[wms:Name='point']/wms:LegendURL/wms:OnlineResource/@xlink:href", doc);
        CapabilitiesIntegrationTest.assertTrue((boolean)href.contains("GetLegendGraphic"));
        CapabilitiesIntegrationTest.assertTrue((boolean)href.contains("layer=Fifteen"));
        CapabilitiesIntegrationTest.assertTrue((boolean)href.contains("style=point"));
    }

    public void testServiceMetadata() throws Exception {
        WMSInfo service = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        service.setTitle("test title");
        service.setAbstract("test abstract");
        service.setAccessConstraints("test accessConstraints");
        service.setFees("test fees");
        service.getKeywords().clear();
        service.getKeywords().add("test keyword 1");
        service.getKeywords().add("test keyword 2");
        service.setMaintainer("test maintainer");
        service.setOnlineResource("http://example.com/geoserver");
        GeoServerInfo global = this.getGeoServer().getGlobal();
        ContactInfo contact = global.getContact();
        contact.setAddress("__address");
        contact.setAddressCity("__city");
        contact.setAddressCountry("__country");
        contact.setAddressPostalCode("__ZIP");
        contact.setAddressState("__state");
        contact.setAddressType("__type");
        contact.setContactEmail("e@mail");
        contact.setContactOrganization("__org");
        contact.setContactFacsimile("__fax");
        contact.setContactPerson("__me");
        contact.setContactPosition("__position");
        contact.setContactVoice("__phone");
        this.getGeoServer().save(global);
        this.getGeoServer().save((ServiceInfo)service);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        String base = "wms:WMS_Capabilities/wms:Service/";
        XMLAssert.assertXpathEvaluatesTo((String)"WMS", (String)(String.valueOf(base) + "wms:Name"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test title", (String)(String.valueOf(base) + "wms:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test abstract", (String)(String.valueOf(base) + "wms:Abstract"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 1", (String)(String.valueOf(base) + "wms:KeywordList/wms:Keyword[1]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 2", (String)(String.valueOf(base) + "wms:KeywordList/wms:Keyword[2]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://example.com/geoserver", (String)(String.valueOf(base) + "wms:OnlineResource/@xlink:href"), (Document)doc);
        String cinfo = String.valueOf(base) + "wms:ContactInformation/";
        XMLAssert.assertXpathEvaluatesTo((String)"__me", (String)(String.valueOf(cinfo) + "wms:ContactPersonPrimary/wms:ContactPerson"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__org", (String)(String.valueOf(cinfo) + "wms:ContactPersonPrimary/wms:ContactOrganization"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__position", (String)(String.valueOf(cinfo) + "wms:ContactPosition"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__type", (String)(String.valueOf(cinfo) + "wms:ContactAddress/wms:AddressType"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__address", (String)(String.valueOf(cinfo) + "wms:ContactAddress/wms:Address"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__city", (String)(String.valueOf(cinfo) + "wms:ContactAddress/wms:City"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__state", (String)(String.valueOf(cinfo) + "wms:ContactAddress/wms:StateOrProvince"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__ZIP", (String)(String.valueOf(cinfo) + "wms:ContactAddress/wms:PostCode"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__country", (String)(String.valueOf(cinfo) + "wms:ContactAddress/wms:Country"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__phone", (String)(String.valueOf(cinfo) + "wms:ContactVoiceTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__fax", (String)(String.valueOf(cinfo) + "wms:ContactFacsimileTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"e@mail", (String)(String.valueOf(cinfo) + "wms:ContactElectronicMailAddress"), (Document)doc);
    }

    public void testQueryable() throws Exception {
        LayerInfo lines = this.getCatalog().getLayerByName(MockData.LINES.getLocalPart());
        lines.setQueryable(true);
        this.getCatalog().save(lines);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        points.setQueryable(false);
        this.getCatalog().save(points);
        String linesName = String.valueOf(MockData.LINES.getPrefix()) + ":" + MockData.LINES.getLocalPart();
        String pointsName = String.valueOf(MockData.POINTS.getPrefix()) + ":" + MockData.POINTS.getLocalPart();
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("//wms:Layer[wms:Name='" + linesName + "']/@queryable"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("//wms:Layer[wms:Name='" + pointsName + "']/@queryable"), (Document)doc);
    }
}

