/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.util.List;
import java.util.Map;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.kvp.MapLayerInfoKvpParser;

public class DescribeLayerKvpRequestReader
extends KvpRequestReader {
    private WMS wms;

    public DescribeLayerKvpRequestReader(WMS wms) {
        super(DescribeLayerRequest.class);
        this.wms = wms;
    }

    public Object read(Object req, Map kvp, Map rawKvp) throws Exception {
        DescribeLayerRequest request = (DescribeLayerRequest)super.read(req, kvp, rawKvp);
        request.setRawKvp(rawKvp);
        String version = request.getVersion();
        if (version == null) {
            String code = "NoVersionInfo";
            String simpleName = ((Object)((Object)this)).getClass().getSimpleName();
            throw new ServiceException("Version parameter not provided for DescribeLayer operation", code, simpleName);
        }
        if (!this.wms.getVersion().equals(version)) {
            throw new ServiceException("Wrong value for version parameter: " + version + ". This server accetps version " + this.wms.getVersion(), "InvalidVersion", ((Object)((Object)this)).getClass().getSimpleName());
        }
        Object layers = new MapLayerInfoKvpParser("LAYERS", this.wms).parse((String)rawKvp.get("LAYERS"));
        request.setLayers((List<MapLayerInfo>)layers);
        if (layers == null || layers.size() == 0) {
            throw new ServiceException("No LAYERS has been requested", "NoLayerRequested", ((Object)((Object)this)).getClass().getName());
        }
        return request;
    }
}

