/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.util.logging.Logging;

public final class TIFFMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(TIFFMapResponse.class);
    private static final ImageWriterSpi writerSPI = new TIFFImageWriterSpi();
    private static final String MIME_TYPE = "image/tiff";
    private static final String IMAGE_TIFF8 = "image/tiff8";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/tiff", "image/tiff8"};

    public TIFFMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContext mapContext) throws ServiceException, IOException {
        GetMapRequest request;
        String format;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a writer for tiff");
        }
        ImageWriter writer = writerSPI.createWriterInstance();
        ImageOutputStream ioutstream = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)outStream);
        if (ioutstream == null) {
            throw new ServiceException("Unable to create ImageOutputStream.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image ...");
        }
        if ((format = (request = mapContext.getRequest()).getFormat()).equalsIgnoreCase(IMAGE_TIFF8) || mapContext.getPaletteInverter() != null) {
            InverseColorMapOp paletteInverter = mapContext.getPaletteInverter();
            image = this.forceIndexed8Bitmask(image, paletteInverter);
        }
        try {
            writer.setOutput(ioutstream);
            writer.write(image);
        }
        finally {
            block18: {
                block17: {
                    try {
                        ioutstream.close();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block17;
                        LOGGER.log(Level.FINEST, "Unable to properly close output stream", e);
                    }
                }
                try {
                    writer.dispose();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block18;
                    LOGGER.log(Level.FINEST, "Unable to properly dispose writer", e);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }
}

