/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultWebMapServiceTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new DefaultWebMapServiceTest());
    }

    public void test1() throws Exception {
        GetMapRequest mockGMR = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        GetMapRequest request = new GetMapRequest();
        DefaultWebMapService reflector = new DefaultWebMapService(this.getWMS());
        request.setLayers(mockGMR.getLayers());
        request.setFormat(DefaultWebMapService.FORMAT);
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        CoordinateReferenceSystem crs = request.getCrs();
        String srs = request.getSRS();
        Envelope bbox = request.getBbox();
        String format = request.getFormat();
        int width = request.getWidth();
        int height = request.getHeight();
        String crsString = crs.getName().toString();
        DefaultWebMapServiceTest.assertTrue((boolean)"EPSG:WGS 84".equalsIgnoreCase(crsString));
        DefaultWebMapServiceTest.assertTrue((boolean)"EPSG:4326".equalsIgnoreCase(srs));
        DefaultWebMapServiceTest.assertTrue((bbox.getMinX() == -180.0 && bbox.getMaxX() == 180.0 && bbox.getMinY() == -90.0 && bbox.getMaxY() == 90.0 ? 1 : 0) != 0);
        DefaultWebMapServiceTest.assertEquals((String)"image/png", (String)format);
        DefaultWebMapServiceTest.assertEquals((int)width, (int)512);
        DefaultWebMapServiceTest.assertEquals((int)height, (int)256);
    }

    public void test2() throws Exception {
        GetMapRequest mockGMR = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        GetMapRequest request = new GetMapRequest();
        DefaultWebMapService reflector = new DefaultWebMapService(this.getWMS());
        request.setSRS("EPSG:41001");
        request.setCrs(CRS.decode((String)"EPSG:41001"));
        request.setLayers(mockGMR.getLayers());
        request.setFormat("image/gif");
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        CoordinateReferenceSystem crs = request.getCrs();
        String srs = request.getSRS();
        Envelope bbox = request.getBbox();
        String format = request.getFormat();
        int width = request.getWidth();
        int height = request.getHeight();
        String crsString = crs.getName().toString();
        DefaultWebMapServiceTest.assertTrue((boolean)"WGS84 / Simple Mercator".equalsIgnoreCase(crsString));
        DefaultWebMapServiceTest.assertTrue((boolean)"EPSG:41001".equalsIgnoreCase(srs));
        DefaultWebMapServiceTest.assertTrue((Math.abs(bbox.getMinX() + 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMinY() + 2.2026354993694823E7) < 1.0E-4 && Math.abs(bbox.getMaxX() - 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMaxY() - 2.2026354993694823E7) < 1.0E-4 ? 1 : 0) != 0);
        DefaultWebMapServiceTest.assertEquals((String)"image/gif", (String)format);
        DefaultWebMapServiceTest.assertEquals((int)447, (int)width);
        DefaultWebMapServiceTest.assertEquals((int)512, (int)height);
    }

    public void test3() throws Exception {
        GetMapRequest mockStreams = this.createGetMapRequest(MockData.BRIDGES);
        GetMapRequest mockBridges = this.createGetMapRequest(MockData.STREAMS);
        ArrayList<MapLayerInfo> mls = new ArrayList<MapLayerInfo>(2);
        mls.add((MapLayerInfo)mockBridges.getLayers().get(0));
        mls.add((MapLayerInfo)mockStreams.getLayers().get(0));
        GetMapRequest request = new GetMapRequest();
        DefaultWebMapService reflector = new DefaultWebMapService(this.getWMS());
        request.setSRS("EPSG:41001");
        request.setCrs(CRS.decode((String)"EPSG:41001"));
        request.setLayers(mls);
        request.setFormat("image/gif");
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        CoordinateReferenceSystem crs = request.getCrs();
        String srs = request.getSRS();
        Envelope bbox = request.getBbox();
        String format = request.getFormat();
        int width = request.getWidth();
        int height = request.getHeight();
        String crsString = crs.getName().toString();
        DefaultWebMapServiceTest.assertTrue((boolean)"WGS84 / Simple Mercator".equalsIgnoreCase(crsString));
        DefaultWebMapServiceTest.assertTrue((boolean)"EPSG:41001".equalsIgnoreCase(srs));
        DefaultWebMapServiceTest.assertTrue((Math.abs(bbox.getMinX() + 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMinY() + 2.2026354993694823E7) < 1.0E-4 && Math.abs(bbox.getMaxX() - 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMaxY() - 2.2026354993694823E7) < 1.0E-4 ? 1 : 0) != 0);
        DefaultWebMapServiceTest.assertEquals((String)"image/gif", (String)format);
        DefaultWebMapServiceTest.assertEquals((int)447, (int)width);
        DefaultWebMapServiceTest.assertEquals((int)512, (int)height);
    }
}

